/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.convert.out.html.HtmlCssHelper;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.BindingTraverserInterface;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io3.stores.UnzippedPartStore;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.CTSdtDate;
import org.docx4j.wml.Color;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTraverserXSLT
implements BindingTraverserInterface {
    private static Logger log = LoggerFactory.getLogger(BindingTraverserXSLT.class);
    static Templates xslt;
    private static DocumentFragment placeholderFragment;
    private static byte[] placeholderBytes;
    private static final String placeholderResource = "org/docx4j/model/datastorage/placeholder.xml";

    @Override
    public Object traverseToBind(JaxbXmlPart part, OpcPackage pkg, XPathsPart xPathsPart) throws Docx4JException {
        Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
        try {
            DOMResult result = new DOMResult();
            HashMap<String, Object> transformParameters = new HashMap<String, Object>();
            transformParameters.put("customXmlDataStorageParts", part.getPackage().getCustomXmlDataStorageParts());
            transformParameters.put("wmlPackage", (WordprocessingMLPackage)pkg);
            transformParameters.put("sourcePart", part);
            transformParameters.put("xPathsPart", xPathsPart);
            XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
            if (log.isDebugEnabled()) {
                Document docResult = (Document)result.getNode();
                log.debug(XmlUtils.w3CDomNodeToString(docResult));
                return XmlUtils.unmarshal(docResult);
            }
            return XmlUtils.unmarshal((Document)result.getNode());
        }
        catch (Exception e) {
            throw new Docx4JException("Problems applying bindings", e);
        }
    }

    public static void log(ExpressionContext expressionContext, String message) {
        log.info("[String] " + message);
    }

    public static void log(NodeIterator nodeIterator) {
        org.w3c.dom.Node n = nodeIterator.nextNode();
        log.info(XmlUtils.w3CDomNodeToString(n));
    }

    public static void logXml(NodeIterator nodeIterator) {
        BindingTraverserXSLT.log(nodeIterator);
    }

    private static DocumentFragment createPlaceholder(RPr rPr, String contentParent) throws Exception {
        if (placeholderFragment == null) {
            BindingTraverserXSLT.createPlaceholderFragment();
        }
        if (placeholderBytes == null) {
            BindingTraverserXSLT.createPlaceholderBytes();
        }
        if (contentParent.equals("p")) {
            if (rPr == null) {
                return placeholderFragment;
            }
            R run = (R)XmlUtils.unmarshal(new ByteArrayInputStream(placeholderBytes));
            run.setRPr(rPr);
            Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
            DocumentFragment docfrag = tmpDoc.createDocumentFragment();
            XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
            return docfrag;
        }
        R run = (R)XmlUtils.unmarshal(new ByteArrayInputStream(placeholderBytes));
        run.setRPr(rPr);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        DocumentFragment docfrag = tmpDoc.createDocumentFragment();
        if (contentParent.equals("tbl")) {
            Element wtr = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tr");
            docfrag.appendChild(wtr);
            Element wtc = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            wtr.appendChild(wtc);
            Element wp = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(tmpDoc.getDocumentElement());
            return docfrag;
        }
        if (contentParent.equals("tr")) {
            Element wtc = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            docfrag.appendChild(wtc);
            Element wp = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(tmpDoc.getDocumentElement());
            return docfrag;
        }
        if (contentParent.equals("tc") || contentParent.equals("body")) {
            Element wp = tmpDoc.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            docfrag.appendChild(wp);
            wp.appendChild(tmpDoc.getDocumentElement());
            return docfrag;
        }
        return null;
    }

    private static void createPlaceholderFragment() throws Exception {
        InputStream is = ResourceUtils.getResource(placeholderResource);
        DocumentBuilderFactory newInstance = DocumentBuilderFactory.newInstance();
        newInstance.setNamespaceAware(true);
        Document tmpDoc = newInstance.newDocumentBuilder().parse(is);
        placeholderFragment = tmpDoc.createDocumentFragment();
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)placeholderFragment);
    }

    private static void createPlaceholderBytes() throws Exception {
        InputStream is = ResourceUtils.getResource(placeholderResource);
        placeholderBytes = IOUtils.toByteArray((InputStream)is);
    }

    public static DocumentFragment convertXHTML(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, XPathsPart xPathsPart, String sdtParent, String contentChild, NodeIterator rPrNodeIt, String tag) {
        log.debug("convertXHTML extension function for: " + sdtParent + "/w:sdt/w:sdtContent/" + contentChild);
        Document docContainer = XmlUtils.neww3cDomDocument();
        DocumentFragment docfrag = docContainer.createDocumentFragment();
        XHTMLImporter xHTMLImporter = null;
        try {
            Class<?> xhtmlImporterClass = Class.forName("org.docx4j.convert.in.xhtml.XHTMLImporterImpl");
            Constructor<?> ctor = xhtmlImporterClass.getConstructor(WordprocessingMLPackage.class);
            xHTMLImporter = (XHTMLImporter)ctor.newInstance(pkg);
        }
        catch (Exception e) {
            log.error("docx4j-XHTMLImport jar not found. Please add this to your classpath.");
            log.error(e.getMessage(), (Throwable)e);
            return BindingTraverserXSLT.xhtmlError(sdtParent, docContainer, docfrag, "Missing XHTML Handler!");
        }
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(tag, true);
        String xpathId = map.get("od:xpath");
        log.info("Looking for xpath by id: " + xpathId);
        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        if (xpath == null) {
            log.warn("Couldn't find xpath with id: " + xpathId);
            return null;
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        String r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings);
        try {
            RPr rPrSDT = null;
            org.w3c.dom.Node rPrNode = rPrNodeIt.nextNode();
            if (rPrNode != null) {
                rPrSDT = (RPr)XmlUtils.unmarshal(rPrNode);
            }
            if (r == null || r.trim().equals("")) {
                return BindingTraverserXSLT.createPlaceholder(rPrSDT, sdtParent);
            }
            if ((r = r.trim()).startsWith("<span")) {
                Tree<StyleTree.AugmentedStyle> cTree;
                Node<StyleTree.AugmentedStyle> asn;
                Style defaultRunStyle = pkg.getMainDocumentPart().getStyleDefinitionsPart(false) != null ? pkg.getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultCharacterStyle() : null;
                String defaultCharacterStyleId = defaultRunStyle.getStyleId() == null ? "DefaultParagraphFont" : defaultRunStyle.getStyleId();
                StyleTree styleTree = pkg.getMainDocumentPart().getStyleTree();
                String classVal = null;
                String rStyleVal = defaultCharacterStyleId;
                if (rPrSDT != null && rPrSDT.getRStyle() != null) {
                    rStyleVal = rPrSDT.getRStyle().getVal();
                }
                if ((asn = (cTree = styleTree.getCharacterStylesTree()).get(rStyleVal)) == null) {
                    log.warn("No style node for: " + rStyleVal);
                } else {
                    classVal = StyleTree.getHtmlClassAttributeValue(cTree, asn);
                }
                String css = null;
                if (rPrSDT != null) {
                    StringBuilder result = new StringBuilder();
                    HtmlCssHelper.createCss(pkg, rPrSDT, result);
                    css = result.toString();
                    if (css.equals("")) {
                        css = null;
                    }
                }
                if (css != null || classVal != null) {
                    r = classVal == null ? "<span style=\"" + css + "\">" + r + "</span>" : (css == null ? "<span class=\"" + classVal + "\">" + r + "</span>" : "<span style=\"" + css + "\" class=\"" + classVal + "\">" + r + "</span>");
                }
                log.debug("\nenhanced with css: \n" + r);
            }
            xHTMLImporter.setHyperlinkStyle(BindingHandler.getHyperlinkResolver().getHyperlinkStyleId());
            String baseUrl = null;
            List<Object> results = null;
            try {
                results = xHTMLImporter.convert(r, baseUrl);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    ((NullPointerException)e).printStackTrace();
                }
                log.error("with XHTML: " + r, (Throwable)e);
                String errMsg = e.getMessage() + " with XHTML from " + xpathExp + " : " + r;
                return BindingTraverserXSLT.xhtmlError(sdtParent, docContainer, docfrag, errMsg);
            }
            if (results == null) {
                log.error("Couldn't convert " + r);
                return docfrag;
            }
            log.info("Got results: " + results.size());
            if (results.size() > 0 && results.get(0) instanceof P && sdtParent.equals("p")) {
                if (results.size() > 1) {
                    log.warn("In paragraph context, so extra block-level content is being discarded!");
                }
                for (Object o : ((P)results.get(0)).getContent()) {
                    Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
                }
            } else {
                for (Object o : results) {
                    String debug = XmlUtils.marshaltoString(o, true);
                    log.debug("Conversion result: " + debug);
                    Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(o);
                    XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
                }
            }
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static DocumentFragment xhtmlError(String sdtParent, Document docContainer, DocumentFragment docfrag, String errMsg) {
        Element wr = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "r");
        Element wt = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t");
        wt.setTextContent(errMsg);
        wr.appendChild(wt);
        if (sdtParent.equals("p")) {
            docfrag.appendChild(wr);
            return docfrag;
        }
        if (sdtParent.equals("tbl")) {
            Element wtr = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tr");
            docfrag.appendChild(wtr);
            Element wtc = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            wtr.appendChild(wtc);
            Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(wr);
            return docfrag;
        }
        if (sdtParent.equals("tr")) {
            Element wtc = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "tc");
            docfrag.appendChild(wtc);
            Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            wtc.appendChild(wp);
            wp.appendChild(wr);
            return docfrag;
        }
        if (sdtParent.equals("tc")) {
            Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
            docfrag.appendChild(wp);
            wp.appendChild(wr);
            return docfrag;
        }
        Element wp = docContainer.createElementNS("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "p");
        docfrag.appendChild(wp);
        wp.appendChild(wr);
        return docfrag;
    }

    public static DocumentFragment xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, XPathsPart xPathsPart, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild, boolean multiLine) {
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String odTag = sdtPr.getTag().getVal();
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:xpath");
        log.debug("Looking for xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag);
        Xpaths.Xpath xpath = null;
        try {
            xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        }
        catch (InputIntegrityException iie) {
            log.error("Couldn't find xpath with id: " + xpathId + " referenced from part " + sourcePart.getPartName().getName() + " at " + odTag);
            throw iie;
        }
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        return BindingTraverserXSLT.xpathGenerateRuns(pkg, sourcePart, customXmlDataStorageParts, storeItemId, xpathExp, prefixMappings, sdtPr, sdtParent, contentChild, multiLine);
    }

    public static DocumentFragment xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, NodeIterator sdtPrNodeIt, String sdtParent, String contentChild, boolean multiLine) {
        SdtPr sdtPr = null;
        org.w3c.dom.Node sdtPrNode = sdtPrNodeIt.nextNode();
        try {
            sdtPr = (SdtPr)XmlUtils.unmarshal(sdtPrNode);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return BindingTraverserXSLT.xpathGenerateRuns(pkg, sourcePart, customXmlDataStorageParts, storeItemId, xpath, prefixMappings, sdtPr, sdtParent, contentChild, multiLine);
    }

    public static DocumentFragment xpathGenerateRuns(WordprocessingMLPackage pkg, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, SdtPr sdtPr, String sdtParent, String contentChild, boolean multiLine) {
        String r = BindingHandler.xpathGetString(pkg, customXmlDataStorageParts, storeItemId, xpath, prefixMappings);
        try {
            log.info(xpath + " yielded result '" + r + "'");
            RPr rPr = null;
            for (Object o : sdtPr.getRPrOrAliasOrLock()) {
                if (!(o instanceof RPr)) continue;
                rPr = (RPr)o;
                break;
            }
            if (r == null || r.equals("")) {
                return BindingTraverserXSLT.createPlaceholder(rPr, "p");
            }
            Document docContainer = XmlUtils.neww3cDomDocument();
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            StringTokenizer st = new StringTokenizer(r, "\n\r\f");
            if (multiLine) {
                boolean firsttoken = true;
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    if (firsttoken) {
                        firsttoken = false;
                    } else {
                        BindingTraverserXSLT.addBrRunToDocFrag(docfrag, rPr);
                    }
                    BindingTraverserXSLT.processString(sourcePart, docfrag, line, rPr);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken());
                }
                BindingTraverserXSLT.processString(sourcePart, docfrag, sb.toString(), rPr);
            }
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void addBrRunToDocFrag(DocumentFragment docfrag, RPr rPr) throws JAXBException {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        run.getRunContent().add(Context.getWmlObjectFactory().createBr());
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
    }

    private static void processString(JaxbXmlPart sourcePart, DocumentFragment docfrag, String text, RPr rPr) throws JAXBException {
        int pos = BindingHandler.getHyperlinkResolver().getIndexOfURL(text);
        if (pos == -1 || BindingHandler.getHyperlinkStyleId() == null) {
            BindingTraverserXSLT.addRunToDocFrag(sourcePart, docfrag, text, rPr);
            return;
        }
        if (pos == 0) {
            int spacePos = text.indexOf(" ");
            if (spacePos == -1) {
                BindingTraverserXSLT.addHyperlinkToDocFrag(sourcePart, docfrag, text);
                return;
            }
            String first = text.substring(0, spacePos);
            String rest = text.substring(spacePos);
            BindingTraverserXSLT.addHyperlinkToDocFrag(sourcePart, docfrag, first);
            BindingTraverserXSLT.processString(sourcePart, docfrag, rest, rPr);
            return;
        }
        String first = text.substring(0, pos);
        String rest = text.substring(pos);
        BindingTraverserXSLT.addRunToDocFrag(sourcePart, docfrag, first, rPr);
        BindingTraverserXSLT.processString(sourcePart, docfrag, rest, rPr);
    }

    private static void addRunToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String string, RPr rPr) {
        R run = Context.getWmlObjectFactory().createR();
        if (rPr != null) {
            run.setRPr(rPr);
        }
        Text text = Context.getWmlObjectFactory().createText();
        run.getRunContent().add(text);
        if (string.startsWith(" ") || string.endsWith(" ")) {
            log.debug("setting xml:space=preserve for '" + string + "'");
            text.setSpace("preserve");
        }
        text.setValue(string);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(run);
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
    }

    private static void addHyperlinkToDocFrag(JaxbXmlPart sourcePart, DocumentFragment docfrag, String url) throws JAXBException {
        org.docx4j.relationships.ObjectFactory factory = new org.docx4j.relationships.ObjectFactory();
        Relationship rel = factory.createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        rel.setTarget(url);
        rel.setTargetMode("External");
        sourcePart.getRelationshipsPart().addRelationship(rel);
        Document tmpDoc = XmlUtils.marshaltoW3CDomDocument(BindingHandler.getHyperlinkResolver().generateHyperlink(rel.getId(), url));
        XmlUtils.treeCopy(tmpDoc.getDocumentElement(), (org.w3c.dom.Node)docfrag);
    }

    public static DocumentFragment xpathInjectImage(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, String cx, String cy) {
        log.info("Falling back to pre-v3 picture processing for " + xpath);
        log.debug("parent: " + sdtParent);
        log.debug("child: " + contentChild);
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            String xpResult = part.getData().xpathGetString(xpath, prefixMappings);
            log.debug(xpath + " yielded result length" + xpResult.length());
            byte[] bytes = Base64.decodeBase64((byte[])xpResult.getBytes("UTF8"));
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wmlPackage, (Part)sourcePart, bytes);
            String filenameHint = null;
            String altText = null;
            int id1 = 0;
            int id2 = 1;
            Inline inline = null;
            long cxl = 0L;
            long cyl = 0L;
            try {
                cxl = Long.parseLong(cx);
                cyl = Long.parseLong(cy);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cxl == 0L || cyl == 0L) {
                log.debug("image size - from image");
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
            } else {
                log.debug("image size - from content control size");
                ImageSize size = imagePart.getImageInfo().getSize();
                double ratio = (double)size.getHeightPx() / (double)size.getWidthPx();
                log.debug("fit ratio: " + ratio);
                if (ratio > 1.0) {
                    cxl = (long)((double)cyl / ratio);
                } else {
                    cyl = (long)((double)cxl * ratio);
                }
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cxl, cyl, false);
            }
            if (wmlPackage.getTargetPartStore() != null && wmlPackage.getTargetPartStore() instanceof UnzippedPartStore) {
                log.debug("incrementally saving " + imagePart.getPartName().getName());
                ((UnzippedPartStore)wmlPackage.getTargetPartStore()).saveBinaryPart(imagePart);
                ByteBuffer bb = null;
                imagePart.setBinaryData(bb);
                imagePart.setImageInfo(null);
            }
            ObjectFactory factory = new ObjectFactory();
            Tc tc = factory.createTc();
            P p = factory.createP();
            if (sdtParent.equals("tr")) {
                tc.getContent().add(p);
            }
            R run = factory.createR();
            Drawing drawing = factory.createDrawing();
            run.getContent().add(drawing);
            drawing.getAnchorOrInline().add(inline);
            if (sdtParent.equals("body") || sdtParent.equals("tr") || sdtParent.equals("tc")) {
                p.getContent().add(run);
            }
            Document document = null;
            if (sdtParent.equals("body") || sdtParent.equals("tc")) {
                document = XmlUtils.marshaltoW3CDomDocument(p);
                log.debug(XmlUtils.marshaltoString((Object)p, true, true));
            } else if (sdtParent.equals("tr")) {
                document = XmlUtils.marshaltoW3CDomDocument(tc);
                log.debug(XmlUtils.marshaltoString((Object)tc, true, true));
            } else if (sdtParent.equals("p")) {
                document = XmlUtils.marshaltoW3CDomDocument(run);
                log.debug(XmlUtils.marshaltoString((Object)run, true, true));
            } else if (sdtParent.equals("sdtContent")) {
                log.info("contentChild: " + contentChild);
                if (contentChild.equals("p")) {
                    p.getContent().add(run);
                    document = XmlUtils.marshaltoW3CDomDocument(p);
                    log.debug(XmlUtils.marshaltoString((Object)p, true, true));
                } else if (contentChild.equals("r")) {
                    document = XmlUtils.marshaltoW3CDomDocument(run);
                    log.debug(XmlUtils.marshaltoString((Object)run, true, true));
                } else {
                    log.error("how to inject image for unexpected sdt's content: " + contentChild);
                }
            } else {
                log.error("how to inject image for unexpected sdt's parent: " + sdtParent);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String xpathInjectImageRelId(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlDataStoragePart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        CustomXmlDataStoragePart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            String xpResult = part.getData().xpathGetString(xpath, prefixMappings);
            log.debug(xpath + " yielded result length" + xpResult.length());
            byte[] bytes = Base64.decodeBase64((byte[])xpResult.getBytes("UTF8"));
            BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wmlPackage, (Part)sourcePart, bytes);
            if (wmlPackage.getTargetPartStore() != null && wmlPackage.getTargetPartStore() instanceof UnzippedPartStore) {
                log.debug("incrementally saving " + imagePart.getPartName().getName());
                ((UnzippedPartStore)wmlPackage.getTargetPartStore()).saveBinaryPart(imagePart);
                ByteBuffer bb = null;
                imagePart.setBinaryData(bb);
                imagePart.setImageInfo(null);
            }
            return imagePart.getRelLast().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRepeatPositionCondition(XPathsPart xPathsPart, String odTag) {
        QueryString qs = new QueryString();
        HashMap<String, String> map = QueryString.parseQueryString(odTag, true);
        String xpathId = map.get("od:RptPosCon");
        log.info("Looking for xpath by id: " + xpathId);
        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)xPathsPart.getJaxbElement(), xpathId);
        String expression = xpath.getDataBinding().getXpath();
        log.info(expression);
        return expression;
    }

    public static DocumentFragment nullResultParagraph(String sdtParent, String message) {
        try {
            ObjectFactory factory = new ObjectFactory();
            R run = factory.createR();
            Text text = factory.createText();
            text.setValue(message);
            run.getContent().add(text);
            Document docContainer = XmlUtils.neww3cDomDocument();
            if (sdtParent.equals("p")) {
                docContainer = XmlUtils.marshaltoW3CDomDocument(run);
            } else {
                P p = factory.createP();
                p.getContent().add(run);
                docContainer = XmlUtils.marshaltoW3CDomDocument(p);
            }
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            docfrag.appendChild(docContainer.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DocumentFragment xpathDate(WordprocessingMLPackage wmlPackage, JaxbXmlPart sourcePart, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, String sdtParent, String contentChild, NodeIterator dateNodeIt) {
        CustomXmlPart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            Date date;
            String r = part.xpathGetString(xpath, prefixMappings);
            log.debug(xpath + " yielded result " + r);
            if (r == null) {
                return BindingTraverserXSLT.nullResultParagraph(sdtParent, "[missing!]");
            }
            CTSdtDate sdtDate = null;
            org.w3c.dom.Node dateNode = dateNodeIt.nextNode();
            if (dateNode != null) {
                sdtDate = (CTSdtDate)XmlUtils.unmarshal(dateNode, Context.jc, CTSdtDate.class);
            }
            if (r.indexOf("Z") > 0) {
                r = r.substring(0, r.indexOf("Z") - 1);
                log.warn("date now " + r);
            }
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String format = sdtDate.getDateFormat().getVal();
            log.debug("Using format: " + format);
            if (format.contains("dddd")) {
                format = format.replace("dddd", "EEEE");
            }
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            ObjectFactory factory = new ObjectFactory();
            RPr rPr = null;
            try {
                date = dateTimeFormat.parse(r);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    date = dateFormat.parse(r);
                }
                catch (ParseException e2) {
                    log.warn(e.getMessage());
                    date = new Date();
                    rPr = factory.createRPr();
                    Color colorRed = factory.createColor();
                    colorRed.setVal("FF0000");
                    rPr.setColor(colorRed);
                }
            }
            String result = formatter.format((Object)date);
            R run = factory.createR();
            if (rPr != null) {
                run.setRPr(rPr);
            }
            Text text = factory.createText();
            text.setValue(result);
            run.getContent().add(text);
            Document docContainer = XmlUtils.neww3cDomDocument();
            if (sdtParent.equals("p")) {
                docContainer = XmlUtils.marshaltoW3CDomDocument(run);
            } else {
                P p = factory.createP();
                p.getContent().add(run);
                docContainer = XmlUtils.marshaltoW3CDomDocument(p);
            }
            DocumentFragment docfrag = docContainer.createDocumentFragment();
            docfrag.appendChild(docContainer.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/datastorage/bind.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        placeholderFragment = null;
        placeholderBytes = null;
    }
}

