/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.PresentationML;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.NotImplementedException;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.pptx4j.Pptx4jException;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.SlideSizesWellKnown;
import org.pptx4j.pml.ObjectFactory;
import org.pptx4j.pml.Presentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainPresentationPart
extends JaxbPmlPart<Presentation> {
    private static final String DEFAULT_SLIDE_SIZE = "<p:sldSz xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\" cx=\"9144000\" cy=\"6858000\" type=\"screen4x3\"/>";
    private static final String DEFAULT_NOTES_SIZE = "<p:notesSz xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\" cx=\"6858000\" cy=\"9144000\"/>";

    public MainPresentationPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public MainPresentationPart() throws InvalidFormatException {
        super(new PartName("/ppt/presentation.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
    }

    public static Presentation.SldSz createSlideSize(SlideSizesWellKnown sz, boolean landscape) {
        Presentation.SldSz sldSz = Context.getpmlObjectFactory().createPresentationSldSz();
        if (sz.equals((Object)SlideSizesWellKnown.LETTER)) {
            sldSz.setType("letter");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.A3)) {
            sldSz.setType("A3");
            if (landscape) {
                sldSz.setCx(12801600);
                sldSz.setCy(9601200);
            } else {
                sldSz.setCx(9601200);
                sldSz.setCy(12801600);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.A4)) {
            sldSz.setType("A4");
            if (landscape) {
                sldSz.setCx(9906000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9906000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.SCREEN4x3)) {
            sldSz.setType("screen4x3");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.SCREEN16x9)) {
            sldSz.setType("screen16x9");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(5143500);
            } else {
                sldSz.setCx(5143500);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.SCREEN16x10)) {
            sldSz.setType("screen16x10");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(5715000);
            } else {
                sldSz.setCx(5715000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.LEDGER)) {
            sldSz.setType("ledger");
            if (landscape) {
                sldSz.setCx(12179300);
                sldSz.setCy(9134475);
            } else {
                sldSz.setCx(9134475);
                sldSz.setCy(12179300);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.B4ISO)) {
            sldSz.setType("B4ISO");
            if (landscape) {
                sldSz.setCx(10826750);
                sldSz.setCy(8120063);
            } else {
                sldSz.setCx(8120063);
                sldSz.setCy(10826750);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.B5ISO)) {
            sldSz.setType("B5ISO");
            if (landscape) {
                sldSz.setCx(7169150);
                sldSz.setCy(5376863);
            } else {
                sldSz.setCx(5376863);
                sldSz.setCy(7169150);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.MM35)) {
            sldSz.setType("35mm");
            if (landscape) {
                sldSz.setCx(10287000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(10287000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.OVERHEAD)) {
            sldSz.setType("overhead");
            if (landscape) {
                sldSz.setCx(9144000);
                sldSz.setCy(6858000);
            } else {
                sldSz.setCx(6858000);
                sldSz.setCy(9144000);
            }
            return sldSz;
        }
        if (sz.equals((Object)SlideSizesWellKnown.BANNER)) {
            sldSz.setType("banner");
            if (landscape) {
                sldSz.setCx(7315200);
                sldSz.setCy(914400);
            } else {
                sldSz.setCx(914400);
                sldSz.setCy(7315200);
            }
            return sldSz;
        }
        throw new NotImplementedException("No support for slide size " + sz.value());
    }

    public static Presentation createJaxbPresentationElement() throws JAXBException {
        return MainPresentationPart.createJaxbPresentationElement(null, true);
    }

    public static Presentation createJaxbPresentationElement(SlideSizesWellKnown sz, boolean landscape) throws JAXBException {
        ObjectFactory factory = Context.getpmlObjectFactory();
        Presentation presentation = factory.createPresentation();
        Presentation.SldMasterIdLst masterIds = factory.createPresentationSldMasterIdLst();
        Presentation.SldIdLst slideIds = factory.createPresentationSldIdLst();
        presentation.setSldMasterIdLst(masterIds);
        presentation.setSldIdLst(slideIds);
        presentation.setNotesSz((CTPositiveSize2D)XmlUtils.unmarshalString(DEFAULT_NOTES_SIZE, Context.jcPML, CTPositiveSize2D.class));
        if (sz == null) {
            presentation.setSldSz((Presentation.SldSz)XmlUtils.unmarshalString(DEFAULT_SLIDE_SIZE, Context.jcPML, Presentation.SldSz.class));
        } else {
            presentation.setSldSz(MainPresentationPart.createSlideSize(sz, landscape));
        }
        return presentation;
    }

    public Presentation.SldIdLst.SldId addSlideIdListEntry(SlidePart slidePart) throws InvalidFormatException {
        return this.addSlideIdListEntry(slidePart, RelationshipsPart.AddPartBehaviour.OVERWRITE_IF_NAME_EXISTS);
    }

    @Deprecated
    public Presentation.SldIdLst.SldId addSlideIdListEntry(SlidePart slidePart, RelationshipsPart.AddPartBehaviour mode) throws InvalidFormatException {
        Relationship rel = this.addTargetPart((Part)slidePart, mode);
        Presentation.SldIdLst.SldId entry = Context.getpmlObjectFactory().createPresentationSldIdLstSldId();
        entry.setId(this.getSlideId());
        entry.setRid(rel.getId());
        ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId().add(entry);
        return entry;
    }

    public Presentation.SldMasterIdLst.SldMasterId addSlideMasterIdListEntry(SlideMasterPart slideMasterPart) throws InvalidFormatException {
        Relationship rel = this.addTargetPart(slideMasterPart);
        Presentation.SldMasterIdLst.SldMasterId entry = Context.getpmlObjectFactory().createPresentationSldMasterIdLstSldMasterId();
        entry.setId(new Long(this.getSlideLayoutOrMasterId()));
        entry.setRid(rel.getId());
        ((Presentation)this.getJaxbElement()).getSldMasterIdLst().getSldMasterId().add(entry);
        return entry;
    }

    public boolean addSlide(SlidePart slidePart) throws Pptx4jException {
        try {
            Relationship rel = this.addTargetPart((Part)slidePart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            return ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId().add(this.createSlideIdListEntry(rel));
        }
        catch (InvalidFormatException e) {
            throw new Pptx4jException(e.getMessage(), e);
        }
    }

    public void addSlide(int index, SlidePart slidePart) throws Pptx4jException {
        List<Presentation.SldIdLst.SldId> sldIds = ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId();
        int zeroBasedCount = sldIds.size();
        if (index < 0 || index > zeroBasedCount) {
            throw new Pptx4jException("Can't add slide at index " + index + ".  (There are " + sldIds.size() + " slides) ");
        }
        try {
            Relationship rel = this.addTargetPart((Part)slidePart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            sldIds.add(index, this.createSlideIdListEntry(rel));
        }
        catch (InvalidFormatException e) {
            throw new Pptx4jException(e.getMessage(), e);
        }
    }

    private Presentation.SldIdLst.SldId createSlideIdListEntry(Relationship rel) throws InvalidFormatException {
        Presentation.SldIdLst.SldId entry = Context.getpmlObjectFactory().createPresentationSldIdLstSldId();
        entry.setId(this.getSlideId());
        entry.setRid(rel.getId());
        return entry;
    }

    public void removeSlide(int index) throws Pptx4jException {
        List<Presentation.SldIdLst.SldId> sldIds = ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId();
        int zeroBasedCount = sldIds.size() - 1;
        if (index < 0 || index > zeroBasedCount) {
            throw new Pptx4jException("No slide at index " + index + ".  (There are " + sldIds.size() + " slides) ");
        }
        Presentation.SldIdLst.SldId entry = ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId().remove(index);
        Relationship rel = this.getRelationshipsPart().getRelationshipByID(entry.getRid());
        Part part = this.getRelationshipsPart().getPart(rel);
        this.getPackage().getParts().remove(part.getPartName());
        this.getRelationshipsPart().removeRelationship(rel);
    }

    public void removeSlide(Relationship rel) throws Pptx4jException {
        if (rel == null) {
            throw new Pptx4jException("Null relationship.");
        }
        int index = -1;
        int i = 0;
        for (Presentation.SldIdLst.SldId entry : ((Presentation)this.getJaxbElement()).getSldIdLst().getSldId()) {
            if (entry.getRid().equals(rel.getId())) {
                index = i;
                break;
            }
            ++i;
        }
        if (index <= -1) {
            throw new Pptx4jException("No slide is the target of that relationship.");
        }
        this.removeSlide(index);
    }
}

