/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWriterRegistry {
    private static final Logger log = LoggerFactory.getLogger(AbstractWriterRegistry.class);
    private Map<String, Writer> writerInstances = new HashMap<String, Writer>();

    public AbstractWriterRegistry() {
        this.registerDefaultWriterInstances();
    }

    protected abstract void registerDefaultWriterInstances();

    public void registerWriter(Writer converter) {
        this.writerInstances.put(converter.getID(), converter);
    }

    public Map<String, Writer.TransformState> createTransformStates() {
        HashMap<String, Writer.TransformState> ret = new HashMap<String, Writer.TransformState>();
        Writer.TransformState state = null;
        for (Map.Entry<String, Writer> item : this.writerInstances.entrySet()) {
            state = item.getValue().createTransformState();
            if (state == null) continue;
            ret.put(item.getKey(), state);
        }
        return ret;
    }

    public Node toNode(AbstractWmlConversionContext context, Node node, NodeList childResults) {
        Object unmarshalledNode = null;
        Document doc = XmlUtils.neww3cDomDocument();
        Node content = childResults != null && childResults.getLength() > 0 ? childResults.item(0) : null;
        Node ret = null;
        try {
            unmarshalledNode = XmlUtils.unmarshal(node);
        }
        catch (JAXBException e) {
            log.error("Cannot unmarshall " + node.getNodeName(), (Throwable)e);
        }
        if (unmarshalledNode != null) {
            ret = this.toNode(context, unmarshalledNode, node.getNodeName(), content, doc);
        }
        return ret;
    }

    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, String modelID, Node content, Document doc) {
        Node ret = null;
        try {
            Writer converter = this.writerInstances.get(modelID);
            if (converter == null) {
                log.warn("No writer registered for " + modelID);
                log.info("Generating wml from model.");
                Document docMarshalled = XmlUtils.marshaltoW3CDomDocument(unmarshalledNode);
                DocumentFragment docfrag = docMarshalled.createDocumentFragment();
                docfrag.appendChild(docMarshalled.getDocumentElement());
                ret = docfrag;
            } else {
                ret = converter.toNode(context, unmarshalledNode, content, context.getTransformState(modelID), doc);
            }
        }
        catch (Exception e) {
            log.error("Cannot convert " + unmarshalledNode, (Throwable)e);
        }
        return ret;
    }
}

