/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.apps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractFontReader {
    protected static Logger log = LoggerFactory.getLogger(AbstractFontReader.class);

    protected static String[] parseArguments(Map options, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if ("-d".equals(args[i]) || "-q".equals(args[i])) {
                    options.put(args[i], "");
                    continue;
                }
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    options.put(args[i], args[i + 1]);
                    ++i;
                    continue;
                }
                options.put(args[i], "");
                continue;
            }
            arguments.add(args[i]);
        }
        return arguments.toArray(new String[0]);
    }

    public void writeFontXML(Document doc, String target) throws TransformerException {
        this.writeFontXML(doc, new File(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFontXML(Document doc, File target) throws TransformerException {
        log.info("Writing xml font file " + target + "...");
        try {
            OutputStream out = new FileOutputStream(target);
            out = new BufferedOutputStream(out);
            try {
                TransformerFactory factory = XmlUtils.getTransformerFactory();
                Transformer transformer = factory.newTransformer();
                transformer.transform(new DOMSource(doc), new StreamResult(out));
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioe) {
            throw new TransformerException("Error writing the output file", ioe);
        }
    }
}

