% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_report}
\alias{plot_report}
\alias{plot_report_bar}
\title{Plot the reporter_res}
\usage{
plot_report(
  reporter_res,
  rs_threshold = 1.64,
  mode = 1,
  y_text_size = 13,
  str_width = 100,
  show_ID = FALSE,
  Pathway_description = TRUE,
  facet_level = FALSE,
  facet_anno = NULL,
  facet_str_width = 15
)
}
\arguments{
\item{reporter_res}{result of `get_reporter_score` or `reporter_score`}

\item{rs_threshold}{plot threshold vector, default:1.64}

\item{mode}{1~2 plot style.}

\item{y_text_size}{y_text_size}

\item{str_width}{str_width to wrap}

\item{show_ID}{show pathway id}

\item{Pathway_description}{show KO description rather than KO id.}

\item{facet_level}{facet plot if the type is "pathway" or "module"}

\item{facet_anno}{annotation table for facet, two columns, first is level summary, second is pathway id.}

\item{facet_str_width}{str width for facet label}
}
\value{
ggplot
}
\description{
Plot the reporter_res
}
\examples{
data("reporter_score_res")
plot_report(reporter_score_res, rs_threshold = c(2.5, -2.5), y_text_size = 10, str_width = 40)
}
