% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_report_circle_packing}
\alias{plot_report_circle_packing}
\title{Plot the reporter_res as circle_packing}
\usage{
plot_report_circle_packing(
  reporter_res,
  rs_threshold = 1.64,
  mode = 2,
  facet_anno = NULL,
  show_ID = FALSE,
  Pathway_description = TRUE,
  str_width = 10,
  show_level_name = "all",
  show_tip_label = TRUE
)
}
\arguments{
\item{reporter_res}{result of `get_reporter_score`}

\item{rs_threshold}{plot threshold vector, default:1.64}

\item{mode}{1~2 plot style.}

\item{facet_anno}{annotation table for facet, more two columns, last is pathway name, last second is pathway id.}

\item{show_ID}{show pathway id}

\item{Pathway_description}{show KO description rather than KO id.}

\item{str_width}{str_width to wrap}

\item{show_level_name}{show the level name?}

\item{show_tip_label}{show the tip label?}
}
\value{
ggplot
}
\description{
Plot the reporter_res as circle_packing
}
\examples{
\donttest{
data("reporter_score_res")
if (requireNamespace("igraph") && requireNamespace("ggraph")) {
  plot_report_circle_packing(reporter_score_res, rs_threshold = c(2, -2), str_width = 40)
}
}
}
