% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup}
\alias{setup}
\alias{setupOff}
\title{Setup a project library, cache, options}
\usage{
setup(
  RPackageFolders = getOption("Require.RPackageFolders", "R"),
  RPackageCache = getOptionRPackageCache(),
  buildBinaries = getOption("Require.buildBinaries", TRUE),
  standAlone = getOption("Require.standAlone", TRUE),
  verbose = getOption("Require.verbose")
)

setupOff(removePackages = FALSE, verbose = getOption("Require.verbose"))
}
\arguments{
\item{RPackageFolders}{One or more folders where R packages are
installed to and loaded from. In the case of more than one
folder provided, installation will only happen in the first one.}

\item{RPackageCache}{See \code{?RequireOptions}.}

\item{buildBinaries}{See \code{?RequireOptions}.}

\item{standAlone}{Logical. If \code{TRUE}, all packages will be installed to and loaded from
the \code{libPaths} only. NOTE: If \code{TRUE}, THIS WILL CHANGE THE USER'S \code{.libPaths()}, similar
to e.g., the \code{checkpoint} package.
If \code{FALSE}, then \code{libPath} will be prepended to \code{.libPaths()} during the \code{Require} call,
resulting in shared packages, i.e., it will include the user's default package folder(s).
This can be create dramatically faster installs if the user has a substantial number of
the packages already in their personal library.
Default \code{FALSE} to minimize package installing.}

\item{verbose}{Numeric or logical indicating how verbose should the function be.
If -1 or less, then as little verbosity as possible.
If 0 or FALSE, then minimal outputs; if \code{1} or TRUE, more outputs; \code{2} even more.
NOTE: in \code{Require} function, when \code{verbose >= 2}, the return object will have an attribute:
\code{attr(.., "Require")} which has lots of information about the processes of the installs.}

\item{removePackages}{Logical. If \code{TRUE}, then all packages that
were installed in the custom library will be deleted when \code{setupOff}
is run. The default is \code{FALSE}, and when \code{TRUE} is selected,
and it is an interactive session, the user will be prompted to confirm
deletions.}
}
\description{
This can be placed as the first line of any/all scripts and it will
be create a reproducible, self-contained project with R packages.
Some of these have direct relationships with \code{RequireOptions}
and arguments in \code{setLibPaths} and \code{Require}.
}
\examples{
\dontrun{
# Place this as the first line of a project
Require::setup()

# To turn it off and return to normal
Require::setupOff()
}

}
