% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTTPError.R
\docType{data}
\name{HTTPError}
\alias{HTTPError}
\title{Helps to generate http error responses}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
\strong{Global Object} which holds functions to raise common http error responses.
Most of the time this class is used jointly with \link{raise}. \cr
For example calling
\code{raise(HTTPError$bad_request(body = "request is invalid"))} from any place in the user code will
interrupt request processing and return response with status code = 404 and body = "request is invalid".
}
\section{Fields}{

\itemize{
\item \strong{\code{content_type}} :: \code{character(1)}\cr
Type of the error response.
\item \strong{\code{encode}} :: \code{function}\cr
Function to encode response body.
}
}

\section{Methods}{

\itemize{
\item \strong{\code{set_content_type}}\code{(content_type)}\cr
\code{character(1)} -> \code{self}\cr
Set content type of response.\cr
\strong{NOTE} that modifying \link{HTTPError} (for example with \code{HTTPError$set_content_type("application/json")})
will have global impact on RestRserve functionality.
By default \code{HTTPError} is used by \link{Application} in order to produce http errors (404, 500, etc).
Hence changing \code{HTTPError} with \code{$set_content_type()} will impact not only user code,
but also the errors format produced by RestRserve. Same holds for \code{$set_encode()} method below.
\item \strong{\code{set_encode}}\code{(encode)}\cr
\code{function} -> \code{self}\cr
Set encode for the given content type.
\item \strong{\code{error}}\code{(status_code, body, ...)}\cr
\code{integer(1)}, \code{raw()} | \code{character()}, \code{...} -> \link{Response}\cr
\code{...} - additional named arguments which will be passed to \code{Response$new(...)}.
\code{headers} may be particularly useful.\cr
Generate HTTP error response with a given status code and body
\item \strong{\code{reset}}\code{()}\cr
-> \code{self} \cr
Resets \code{HTTPError} to the default RestRserve state.
\item \strong{\code{bad_request}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{unauthorized}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{forbidden}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{not_found}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{method_not_allowed}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{not_acceptable}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{conflict}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{gone}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{length_required}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{precondition_failed}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{payload_too_large}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{uri_too_long}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{unsupported_media_type}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{range_not_satisfiable}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{unprocessable_entity}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{locked}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{failed_dependency}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{precondition_required}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{too_many_requests}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{request_header_fields_too_large}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{unavailable_for_legal_reasons}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{internal_server_error}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{not_implemented}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{bad_gateway}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{service_unavailable}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{gateway_timeout}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{version_not_supported}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{insufficient_storage}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{loop_detected}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.
\item \strong{\code{network_authentication_required}}\code{(...)}\cr
\code{...} -> \code{[Response]}\cr
Generates corresponding http error.\cr
}
}

\examples{
check_list = function(x) {
  if (!is.list(x)) raise(HTTPError$bad_request())
  invisible(TRUE)
}
check_list(list())
try(check_list(1), silent = TRUE)
}
\seealso{
\link{raise} \link{Application}
}
\keyword{datasets}
