% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{nullModelFitting}
\alias{nullModelFitting}
\title{Fit base model}
\usage{
nullModelFitting(
  theta_start,
  M,
  y,
  V,
  psiLB,
  psiUB,
  maxit,
  factr,
  pgtol,
  lmm,
  VCNs,
  nObs,
  trace = TRUE
)
}
\arguments{
\item{theta_start}{p-dimensional vector parameter used as initial guess in the inference procedure.}

\item{M}{A \eqn{n \times K}{n by K} dimensional (design) matrix.}

\item{y}{n-dimensional vector of the time-adjacent cellular increments}

\item{V}{A \eqn{p \times K}{p by K} dimensional net-effect matrix.}

\item{psiLB}{p-dimensional vector of lower bound values for theta.}

\item{psiUB}{p-dimensional vector of upper bound values for theta.}

\item{maxit}{maximum number of iterations for the optimization step.
This argument is passed to optim() function. Details on "maxit" can be found in "optim()" documentation page.}

\item{factr}{controls the convergence of the "L-BFGS-B" method.
Convergence occurs when the reduction in the objective is within this factor of the machine tolerance.
Default is 1e7, that is a tolerance of about 1e-8.
This argument is passed to optim() function.}

\item{pgtol}{helps control the convergence of the "L-BFGS-B" method.
It is a tolerance on the projected gradient in the current search direction.
This defaults to zero, when the check is suppressed.
This argument is passed to optim() function.}

\item{lmm}{is an integer giving the number of BFGS updates retained in the "L-BFGS-B" method, It defaults to 5.
This argument is passed to optim() function.}

\item{VCNs}{A n-dimensional vector including values of the vector copy number corresponding to the cell counts of y.}

\item{nObs}{A K-dimensional vector including the frequencies of each clone k (\eqn{k = 1,\dots,K}{k = 1,..,K}).}

\item{trace}{Non-negative integer. If positive, tracing information on the progress of the optimization is produced.
This parameter is also passed to the optim() function.
Higher values may produce more tracing information: for method "L-BFGS-B" there are six levels of tracing.
(To understand exactly what these do see the source code: higher levels give more detail.)}
}
\value{
A 3-length list. First element is the output returned by "optim()" function (see "optim()" documentation for details).
Second element is a vector of statistics associated to the fitted null model:
\itemize{
\item{"nPar"}{number of parameters of the base(null) model}
\item{"cll"}{value of the conditional log-likelihood, in this case just the log-likelihood}
\item{"mll"}{value of the marginal log-likelihood, in this case just the log-likelihood}
\item{"cAIC"}{conditional Akaike Information Criterion (cAIC), in this case simply the AIC.}
\item{"mAIC"}{marginal Akaike Information Criterion (mAIC), in this case simply the AIC.}
\item{"Chi2"}{value of the \eqn{\chi^2}{Chi-squared} statistic \eqn{(y - M\theta)'S^{-1}(y - M\theta)}{(y - Mθ)'S^-1(y - Mθ)}.}
\item{"p-value"}{p-value of the \eqn{\chi^2}{Chi-squared} test for the null hypothesis that Chi2
follows a \eqn{\chi^2}{Chi-squared} distribution with n - nPar degrees of freedom.}
}
The third element, called "design", is a list including:
\itemize{
\item{"M"}{A \eqn{n \times K}{n by K} dimensional (design) matrix.}
\item{"V"}{A \eqn{p \times K}{p by K} dimensional net-effect matrix.}
}
}
\description{
Fit the base (null) model to the given data using a maximum likelihood approach.
}
\keyword{internal}
