% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_gof.R
\docType{methods}
\name{rc_gof}
\alias{rc_gof}
\title{Goodness of fit of the Return Curve estimates}
\usage{
rc_gof(retcurve, blocksize = 1, nboot = 250, nangles = 150, alpha = 0.05)
}
\arguments{
\item{retcurve}{An S4 object of class \code{rc_est.class}. See \code{\link{rc_est}} for more details.}

\item{blocksize}{Size of the blocks for the block bootstrap procedure. If \code{1} (default), then a standard bootstrap approach is applied.}

\item{nboot}{Number of bootstrap samples to be taken. Default is \code{250} samples.}

\item{nangles}{\loadmathjax{} Number of angles \mjeqn{m}{m} in the interval \mjeqn{(0, \pi/2)}{} \insertCite{MurphyBarltropetal2023}{ReturnCurves}. Default is \code{150} angles.}

\item{alpha}{Significance level to compute the \mjeqn{(1-\alpha)}{}\% confidence intervals. Default is \code{0.05}.}
}
\value{
An object of S4 class \code{rc_gof.class}. This object returns the arguments of the function and an extra slot \code{gof} which is a list containing:
\item{median}{A vector containing the median of the empirical probability of lying in a survival region.} 
\item{lower}{A vector containing the lower bound of the confidence interval.}
\item{upper}{A vector containing the upper bound of the confidence interval.}
}
\description{
Assessment of the goodness-of-fit of the return curve estimates following the approach of \insertCite{MurphyBarltropetal2023;textual}{ReturnCurves}.
}
\details{
Given a return curve RC(\mjeqn{p}{p}), the probability of lying in a survival region is \mjeqn{p}{p}. 
Let \mjdeqn{\boldsymbol{\Theta}:= \left\lbrace \frac{\pi(m+1-j)}{2(m+1)} \mid 1\leq j\leq m\right\rbrace}{} be a set of angles decreasing from near \mjeqn{\pi/2}{} to \mjeqn{0}{0}.
For each angle \mjeqn{\theta_j\in \boldsymbol{\Theta,}}{} and corresponding point in the estimated return curve \mjeqn{\lbrace (\hat{x}_{\theta_j}, \hat{y}_{\theta_j}) \rbrace}{}, 
the empirical probability \mjeqn{\hat{p}_j}{p} of lying in the survival region is given by the proportion of points in the region
\mjeqn{(\hat{x}_{\theta_j}, \infty) \times (\hat{y}_{\theta_j}, \infty)}{}.

Thus, for each angle \mjeqn{\theta_j\in \boldsymbol{\Theta,}}{} a (block) bootstrap procedure to the original data set is applied, and
the empirical probabilities \mjeqn{\hat{p}_j}{} estimated. Then, the median and \mjeqn{(1-\alpha)}{}\% pointwise confidence intervals are obtained for each \mjeqn{\theta_j}{}.
Function \code{plot} shows the median of \mjeqn{\hat{p}_j}{}, the confidence intervals and the true probability \mjeqn{p}{p}; ideally, this value should be contained in the confidence region.

We note that due to the use of empirical probabilities, the value of \mjeqn{p}{p} should be within the range of the data and not too extreme.
}
\examples{
library(ReturnCurves)

data(airdata)

n <- dim(airdata)[1]

prob <- 10/n

margdata <- margtransf(airdata)

rc_orig <- rc_est(margdata = margdata, p = prob, method = "hill")

# blocksize to account for temporal dependence
gof <- rc_gof(retcurve = rc_orig, blocksize = 10)

plot(gof)

# To see the the S4 object's slots
str(gof)

# To access the list of vectors
gof@gof

}
\references{
\insertAllCited{}
}
