% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{setExperigenCredentials}
\alias{setExperigenCredentials}
\title{Sets up the experimenter credentials for the further requests.
It can also check whether the authentication is successful.}
\usage{
setExperigenCredentials(experimenter, password, check = TRUE, quiet = FALSE)
}
\arguments{
\item{experimenter}{The experimenter username}

\item{password}{The password for the experimenter}

\item{check}{Whether to check if the experimenter is registered.}

\item{quiet}{If \code{TRUE}, the function will not print out the
result of the existence check}
}
\value{
Whether the existence check is successful. If \code{check = FALSE},
it will return \code{TRUE} by default
}
\description{
Sets up the experimenter credentials for the further requests.
It can also check whether the authentication is successful.
}
\examples{
\dontrun{
setExperigenCredentials("joesmith", "1234")
}
setExperigenCredentials("janemiller", "passdrow", check = FALSE)

}
\seealso{
Other setup: \code{\link{setExperigenServer}}
}

