\name{Many score based GLM regressions}
\alias{score.glms}
\alias{score.multinomregs}
\title{
Many score based GLM regressions
}

\description{
Many score based GLM regressions.
}

\usage{
score.glms(y, x, oiko = NULL, logged = FALSE ) 
score.multinomregs(y, x, logged = FALSE ) 
}

\arguments{
\item{y}{
A vector with either discrete or binary data for the Poisson and binary logistic regression respectively. Otherwise it is a vector with discrete values or 
factor values for the multinomial regression. If the vector is binary and choose multinomial regression the function checks and transfers to the binary logistic regression.
}
\item{x}{
A matrix with data, the predictor variables. 
}
\item{oiko}{
This can be either "poisson" or "binomial". If you are not sure leave it NULL and the function will check internally. 
}
\item{logged}{
A boolean variable; it will return the logarithm of the pvalue if set to TRUE.
}
}

\details{
Instead of maximising the log-likelihood via the Newton-Raphson algorithm in order to perform the hypothesis testing that \eqn{\beta_i=0} we use the score test. 
This is dramatcially faster as no model need to be fitted. The first derivative of the log-likelihood is known in closed form and under the null hypothesis the 
fitted values are all equal to the mean of the response variable y. The testis not the same as the likelihood ratio test. It is size correct nonetheless but it 
is a bit less efficient and less powerful. For big sample sizes though (5000 or more) the results are the same. It is also much faster then the classical likelihood ratio test.  
}

\value{
A matrix with two columns, the test statistic and its associated p-value. For the Poisson and logistic regression the p-value is derived via the t distribution, whereas for the multinomial regression via the \eqn{\chi^2} distribution. 
}

\references{
Draper, N.R. and Smith H. (1988). Applied regression analysis. New York, Wiley, 3rd edition.

McCullagh, Peter, and John A. Nelder. Generalized linear models.  CRC press, USA, 2nd edition, 1989.

Agresti Alan (1996). An introduction to categorical data analysis. New York: Wiley.
}

\author{
Michail Tsagris

R implementation and documentation: Michail Tsagris <mtsagris@yahoo.gr> and Manos Papadakis <papadakm95@gmail.com>.
}
%\note{
%%  ~~further notes~~
%}

\seealso{
\code{ \link{univglms}, \link{logistic_only},  \link{poisson_only}, \link{regression}
}
}

\examples{
## 200 variables, hence 200 univariate regressions are to be fitted
x <- matrix( rnorm(100 * 200), ncol = 200 )
y <- rbinom(100, 1, 0.6)   ## binary logistic regression
system.time( univglms(y, x) )
a1 <- univglms(y, x) 
system.time( score.glms(y, x) )
a2 <- score.glms(y, x)
cor(a1, a2)
mean(a1 - a2)

#x <- matrix( rnorm(1000 * 2000), ncol = 2000 )
#y <- rbinom(1000, 1, 0.6)   ## binary logistic regression
#a1 <- univglms(y, x) 
#a2 <- score.glms(y, x)
#cor(a1, a2)
#mean(a1 - a2)

## x <- matrix( rnorm(500 * 2000), ncol = 2000 )
## y <- rbinom(500, 3, 0.5)   
## a <- score.multinomegs(y, x)
## hist(a[, 2])
## sum(a < 0.05) / 2000  ## estimated type I error 
}

\keyword{ GLMS }
\keyword{ multinomial regressions }
\keyword{ score based tests }