% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftscor.R
\name{cor.fts}
\alias{cor.fts}
\title{Correlation for Functional Time Series Objects}
\usage{
cor.fts(Y1, Y2)
}
\arguments{
\item{Y1}{An object of class \code{\link{fts}}.}

\item{Y2}{An object of class \code{\link{fts}}.}
}
\value{
A scalar that is the correlation between \code{\link{fts}} objects.
}
\description{
This function finds the correlation between univariate or multivariate functional time series (\code{\link{fts}}) objects.
}
\examples{
\dontrun{
require(Rfssa)
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Jambi.RData")
## Raw image data
NDVI <- Jambi$NDVI
EVI <- Jambi$EVI
## Kernel density estimation of pixel intensity
D0_NDVI <- matrix(NA, nrow = 512, ncol = 448)
D0_EVI <- matrix(NA, nrow = 512, ncol = 448)
for (i in 1:448) {
  D0_NDVI[, i] <- density(NDVI[, , i], from = 0, to = 1)$y
  D0_EVI[, i] <- density(EVI[, , i], from = 0, to = 1)$y
}
d <- 11
u <- seq(0, 1, length.out = 512)
Y_1 <- fts(list(D0_NDVI), list(list(d, "bspline")), list(u))
Y_2 <- fts(list(D0_EVI), list(list(d, "bspline")), list(u))
out <- cor.fts(Y_1, Y_2)
print(out)
}

}
\seealso{
\code{\link{fts}}
}
