% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funts_methods.R
\name{eval.funts}
\alias{eval.funts}
\title{Evaluate a Functional Time Series (funts) Object on a Given Grid}
\usage{
eval.funts(argvals, obj)
}
\arguments{
\item{argvals}{a list or numeric vector specifying the grid points at which
to evaluate the functional time series. For multivariate functional data,
provide a list of grids corresponding to each dimension.}

\item{obj}{an object of class \code{\link{funts}} to be evaluated.}
}
\value{
A list of matrices, where each matrix represents the evaluated values
  of the functional data on the specified grid.
}
\description{
This function allows you to evaluate a Functional Time Series (funts) object
on a specified grid of argument values. The result is a list of matrices, each
matrix corresponding to one dimension of the functional data.
}
\details{
The \code{argvals} argument can be a list of grids for multivariate functional data.
The function handles both functional basis and empirical basis cases for evaluation.
For empirical basis with irregular grids, a warning is issued as this feature
is under development.
}
\examples{
data("Montana")
y <- Montana
u <- seq(0, 23, len = 4)
v <- seq(1, 33, len = 3)
grid <- list(u, list(v, v))
eval.funts(grid, y)
}
\seealso{
\code{\link{funts}}
}
