% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmean.R
\name{rmean}
\alias{rmean}
\title{Robust Fréchet Mean of Manifold-valued Data}
\usage{
rmean(input, k = 5, maxiter = 496, eps = 1e-06, parallel = FALSE)
}
\arguments{
\item{input}{a S3 object of \code{riemdata} class. See \code{\link{riemfactory}} for more details.}

\item{k}{number of subsets for which the data be divided into.}

\item{maxiter}{maximum number of iterations for gradient descent algorithm and Weiszfeld algorithm.}

\item{eps}{stopping criterion for the norm of gradient.}

\item{parallel}{a flag for enabling parallel computation.}
}
\value{
a named list containing
\describe{
\item{x}{an estimate geometric median.}
\item{iteration}{number of iterations until convergence.}
}
}
\description{
Robust estimator for mean starts from dividing the data \eqn{\{x_i\}_{i=1}^n} into \eqn{k} equally sized 
sets. For each subset, it first estimates Fréchet mean. It then follows a step to aggregate 
\eqn{k} sample means by finding a geometric median.
}
\examples{
\donttest{
### Generate 100 data points on Sphere S^2 near (0,0,1).
ndata = 100
theta = seq(from=-0.99,to=0.99,length.out=ndata)*pi
tmpx  = cos(theta) + rnorm(ndata,sd=0.1)
tmpy  = sin(theta) + rnorm(ndata,sd=0.1)

### Wrap it as 'riemdata' class
data  = list()
for (i in 1:ndata){
  tgt = c(tmpx[i],tmpy[i],1)
  data[[i]] = tgt/sqrt(sum(tgt^2)) # project onto Sphere
}
data = riemfactory(data, name="sphere")

### Compute Robust Fréchet Mean
out1 = RiemBase::rmean(data)
out2 = RiemBase::rmean(data,parallel=TRUE) # test parallel implementation
}

}
\references{
\insertRef{2011arXiv1112.3914L}{RiemBase}

\insertRef{2013arXiv1308.1334M}{RiemBase}

\insertRef{2014arXiv1409.5937F}{RiemBase}
}
\seealso{
\code{\link[RiemBase]{mean}}, \code{\link[RiemBase]{median}}
}
\author{
Kisung You
}
