% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{ig_get_followers}
\alias{ig_get_followers}
\alias{ig_get_following}
\title{Get Follower Info}
\usage{
ig_get_followers(user_id, max_id = NULL, return_df = TRUE,
  paginate = TRUE, max_pages = 10, verbose = FALSE)

ig_get_following(user_id, max_id = NULL, return_df = TRUE,
  paginate = TRUE, max_pages = 10, verbose = FALSE)
}
\arguments{
\item{user_id}{numeric; the unique id to identify an Instagram user which can be 
found in the \code{"pk"} field on a \code{user} object}

\item{max_id}{integer; the unique id identifying the oldest post that you 
would want to retrieve in this function call}

\item{return_df}{logical; do you want to return the results as a \code{tbl_df} 
with one row per entity or as a list with one element per entity?}

\item{paginate}{logical; do you want to paginate through results or just return 
the first page?}

\item{max_pages}{integer; a limit to the number of pages to retrieve from 
paginated endpoints. Instagram feeds have the potential to paginate forever, 
so by default we stop after pulling 10 pages. If you would like more or less 
pages returned, then modify this argument.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
These function returns all of the followers or users that a specific user is following
}
\examples{
\donttest{
bieber_user_id <- ig_get_user_id("justinbieber")

# By default, ig_get_followers will retrieve the top 10 pages of follower data. 
# This is because IG users like Justin Bieber have 100M+ followers, so it could 
# take a long time to pull. If you would really like to get all users, then set
# the max_pages argument to Inf.
bieber_followers <- ig_get_followers(bieber_user_id)
bieber_following <- ig_get_following(bieber_user_id)
}
}
