% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{popSD}
\alias{popSD}
\title{Converts Sample Standard Deviations into Population Equivalents}
\usage{
popSD(s, n)
}
\arguments{
\item{s}{The sample SD(s) (vector)}

\item{n}{The sample-size for each SD to be converted (vector)}
}
\value{
The population SD(s) (vector)
}
\description{
This function converts a sample standard deviation (SD) input into the population equivalent. This code
is vectorized to convert several sample standard deviations for univariate distributions of identical
sample-sizes, if desired.
}
\examples{
values <- rnorm(100)
x <- popSD(s = sd(values),n = 100)
}
\references{
Ruscio, J. (2021). Fundamentals of research design and statistical analysis. Ewing, NJ:
            The College of New Jersey, Psychology Department.
}
