% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/australia.R
\name{get_monthly}
\alias{get_monthly}
\title{get_monthly}
\usage{
get_monthly(
  parameter_type,
  station_number,
  start_date,
  end_date,
  tz,
  return_fields
)
}
\arguments{
\item{parameter_type}{Parameter value}

\item{station_number}{Station number}

\item{start_date}{Start date (formatted as YYYY-MM-DD) or just the
year (YYYY)}

\item{end_date}{End date (formatted as YYYY-MM-DD) or just the year (YYYY)}

\item{tz}{TZ}

\item{return_fields}{Return fields}
}
\value{
A tibble with the requested return fields. Zero row tibbles are returned if no data is available for the requested dates. The aggregation of data is generally the mean for most variables, except for rainfall and evaporation which is the sum over the chosen period.
}
\description{
get_monthly
}
\examples{
# Monthly average dry air temperature at Corin Dam
\dontrun{
get_monthly(
  parameter_type = "Dry Air Temperature",
  station_number = "570947",
  start_date = "2016-01-01",
  end_date = "2016-06-01"
)
}
}
