/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Message;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.ByteSequenceData;
import org.apache.activemq.util.JMSExceptionSupport;

public class ActiveMQBytesMessage
extends ActiveMQMessage
implements BytesMessage {
    public static final byte DATA_STRUCTURE_TYPE = 24;
    protected transient DataOutputStream dataOut;
    protected transient ByteArrayOutputStream bytesOut;
    protected transient DataInputStream dataIn;
    protected transient int length;

    public Message copy() {
        ActiveMQBytesMessage copy = new ActiveMQBytesMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQBytesMessage copy) {
        this.storeContent();
        super.copy(copy);
        copy.dataOut = null;
        copy.bytesOut = null;
        copy.dataIn = null;
    }

    public void onSend() throws JMSException {
        super.onSend();
        this.storeContent();
    }

    private void storeContent() {
        try {
            if (this.dataOut != null) {
                this.dataOut.close();
                ByteSequence bs = this.bytesOut.toByteSequence();
                if (this.compressed) {
                    int pos = bs.offset;
                    ByteSequenceData.writeIntBig(bs, this.length);
                    bs.offset = pos;
                }
                this.setContent(bs);
                this.bytesOut = null;
                this.dataOut = null;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage(), ioe);
        }
    }

    public byte getDataStructureType() {
        return 24;
    }

    public String getJMSXMimeType() {
        return "jms/bytes-message";
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    public long getBodyLength() throws JMSException {
        this.initializeReading();
        return this.length;
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.initializeReading();
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (EOFException e) {
            throw JMSExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionSupport.createMessageFormatException(e);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value, offset, length);
        }
        catch (IOException ioe) {
            throw JMSExceptionSupport.create(ioe);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void reset() throws JMSException {
        this.storeContent();
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
        this.setReadOnlyBody(true);
    }

    private void initializeWriting() throws JMSException {
        this.checkReadOnlyBody();
        if (this.dataOut == null) {
            OutputStream os = this.bytesOut = new ByteArrayOutputStream();
            ActiveMQConnection connection = this.getConnection();
            if (connection != null && connection.isUseCompression()) {
                try {
                    os.write(new byte[4]);
                }
                catch (IOException e) {
                    throw JMSExceptionSupport.create(e);
                }
                this.length = 0;
                this.compressed = true;
                final Deflater deflater = new Deflater(1);
                os = new FilterOutputStream(new DeflaterOutputStream(os, deflater)){

                    public void write(byte[] arg0) throws IOException {
                        ActiveMQBytesMessage.this.length += arg0.length;
                        this.out.write(arg0);
                    }

                    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
                        ActiveMQBytesMessage.this.length += arg2;
                        this.out.write(arg0, arg1, arg2);
                    }

                    public void write(int arg0) throws IOException {
                        ++ActiveMQBytesMessage.this.length;
                        this.out.write(arg0);
                    }

                    public void close() throws IOException {
                        super.close();
                        deflater.end();
                    }
                };
            }
            this.dataOut = new DataOutputStream(os);
        }
    }

    protected void checkWriteOnlyBody() throws MessageNotReadableException {
        if (!this.readOnlyBody) {
            throw new MessageNotReadableException("Message body is write-only");
        }
    }

    private void initializeReading() throws JMSException {
        this.checkWriteOnlyBody();
        if (this.dataIn == null) {
            ByteSequence data = this.getContent();
            if (data == null) {
                data = new ByteSequence(new byte[0], 0, 0);
            }
            InputStream is = new ByteArrayInputStream(data);
            if (this.isCompressed()) {
                try {
                    DataInputStream dis = new DataInputStream(is);
                    this.length = dis.readInt();
                    dis.close();
                }
                catch (IOException e) {
                    throw JMSExceptionSupport.create(e);
                }
                is = new InflaterInputStream(is);
            } else {
                this.length = data.getLength();
            }
            this.dataIn = new DataInputStream(is);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.initializeWriting();
        super.setObjectProperty(name, value);
    }

    public String toString() {
        return super.toString() + " ActiveMQBytesMessage{ " + "bytesOut = " + this.bytesOut + ", dataOut = " + this.dataOut + ", dataIn = " + this.dataIn + " }";
    }
}

