/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.LDAPLoginProperty;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPLoginModule
implements LoginModule {
    private static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    private static final String CONNECTION_URL = "connectionURL";
    private static final String CONNECTION_USERNAME = "connectionUsername";
    private static final String CONNECTION_PASSWORD = "connectionPassword";
    private static final String CONNECTION_PROTOCOL = "connectionProtocol";
    private static final String AUTHENTICATION = "authentication";
    private static final String USER_BASE = "userBase";
    private static final String USER_SEARCH_MATCHING = "userSearchMatching";
    private static final String USER_SEARCH_SUBTREE = "userSearchSubtree";
    private static final String ROLE_BASE = "roleBase";
    private static final String ROLE_NAME = "roleName";
    private static final String ROLE_SEARCH_MATCHING = "roleSearchMatching";
    private static final String ROLE_SEARCH_SUBTREE = "roleSearchSubtree";
    private static final String USER_ROLE_NAME = "userRoleName";
    private static Log log = LogFactory.getLog(LDAPLoginModule.class);
    protected DirContext context;
    private Subject subject;
    private CallbackHandler handler;
    private LDAPLoginProperty[] config;
    private String username;
    private Set<GroupPrincipal> groups = new HashSet<GroupPrincipal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.config = new LDAPLoginProperty[]{new LDAPLoginProperty(INITIAL_CONTEXT_FACTORY, (String)options.get(INITIAL_CONTEXT_FACTORY)), new LDAPLoginProperty(CONNECTION_URL, (String)options.get(CONNECTION_URL)), new LDAPLoginProperty(CONNECTION_USERNAME, (String)options.get(CONNECTION_USERNAME)), new LDAPLoginProperty(CONNECTION_PASSWORD, (String)options.get(CONNECTION_PASSWORD)), new LDAPLoginProperty(CONNECTION_PROTOCOL, (String)options.get(CONNECTION_PROTOCOL)), new LDAPLoginProperty(AUTHENTICATION, (String)options.get(AUTHENTICATION)), new LDAPLoginProperty(USER_BASE, (String)options.get(USER_BASE)), new LDAPLoginProperty(USER_SEARCH_MATCHING, (String)options.get(USER_SEARCH_MATCHING)), new LDAPLoginProperty(USER_SEARCH_SUBTREE, (String)options.get(USER_SEARCH_SUBTREE)), new LDAPLoginProperty(ROLE_BASE, (String)options.get(ROLE_BASE)), new LDAPLoginProperty(ROLE_NAME, (String)options.get(ROLE_NAME)), new LDAPLoginProperty(ROLE_SEARCH_MATCHING, (String)options.get(ROLE_SEARCH_MATCHING)), new LDAPLoginProperty(ROLE_SEARCH_SUBTREE, (String)options.get(ROLE_SEARCH_SUBTREE)), new LDAPLoginProperty(USER_ROLE_NAME, (String)options.get(USER_ROLE_NAME))};
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null) {
            return false;
        }
        String password = ((PasswordCallback)callbacks[1]).getPassword() != null ? new String(((PasswordCallback)callbacks[1]).getPassword()) : "";
        try {
            boolean result = this.authenticate(this.username, password);
            if (!result) {
                throw new FailedLoginException();
            }
            return true;
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("LDAP Error").initCause(e);
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.username = null;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new UserPrincipal(this.username));
        Iterator<GroupPrincipal> iter = this.groups.iterator();
        while (iter.hasNext()) {
            principals.add(iter.next());
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.username = null;
        return true;
    }

    protected void close(DirContext context) {
        try {
            context.close();
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    protected boolean authenticate(String username, String password) throws Exception {
        block14: {
            DirContext context = null;
            context = this.open();
            if (!this.isLoginPropertySet(USER_SEARCH_MATCHING)) {
                return false;
            }
            MessageFormat userSearchMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(USER_SEARCH_MATCHING));
            boolean userSearchSubtreeBool = Boolean.valueOf(this.getLDAPPropertyValue(USER_SEARCH_SUBTREE));
            try {
                String filter = userSearchMatchingFormat.format(new String[]{username});
                SearchControls constraints = new SearchControls();
                if (userSearchSubtreeBool) {
                    constraints.setSearchScope(2);
                } else {
                    constraints.setSearchScope(1);
                }
                ArrayList<String> list = new ArrayList<String>();
                if (this.isLoginPropertySet(USER_ROLE_NAME)) {
                    list.add(this.getLDAPPropertyValue(USER_ROLE_NAME));
                }
                String[] attribs = new String[list.size()];
                list.toArray(attribs);
                constraints.setReturningAttributes(attribs);
                NamingEnumeration<SearchResult> results = context.search(this.getLDAPPropertyValue(USER_BASE), filter, constraints);
                if (results == null || !results.hasMore()) {
                    return false;
                }
                SearchResult result = results.next();
                if (results.hasMore()) {
                    // empty if block
                }
                NameParser parser = context.getNameParser("");
                Name contextName = parser.parse(context.getNameInNamespace());
                Name baseName = parser.parse(this.getLDAPPropertyValue(USER_BASE));
                Name entryName = parser.parse(result.getName());
                Name name = contextName.addAll(baseName);
                name = name.addAll(entryName);
                String dn = name.toString();
                Attributes attrs = result.getAttributes();
                if (attrs == null) {
                    return false;
                }
                ArrayList<String> roles = null;
                if (this.isLoginPropertySet(USER_ROLE_NAME)) {
                    roles = this.addAttributeValues(this.getLDAPPropertyValue(USER_ROLE_NAME), attrs, roles);
                }
                if (this.bindUser(context, dn, password)) {
                    roles = this.getRoles(context, dn, username, roles);
                    for (int i = 0; i < roles.size(); ++i) {
                        this.groups.add(new GroupPrincipal(roles.get(i)));
                    }
                    break block14;
                }
                return false;
            }
            catch (CommunicationException e) {
            }
            catch (NamingException e) {
                if (context != null) {
                    this.close(context);
                }
                return false;
            }
        }
        return true;
    }

    protected ArrayList<String> getRoles(DirContext context, String dn, String username, ArrayList<String> currentRoles) throws NamingException {
        ArrayList<String> list = currentRoles;
        MessageFormat roleSearchMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(ROLE_SEARCH_MATCHING));
        boolean roleSearchSubtreeBool = Boolean.valueOf(this.getLDAPPropertyValue(ROLE_SEARCH_SUBTREE));
        if (list == null) {
            list = new ArrayList();
        }
        if (!this.isLoginPropertySet(ROLE_NAME)) {
            return list;
        }
        String filter = roleSearchMatchingFormat.format(new String[]{this.doRFC2254Encoding(dn), username});
        SearchControls constraints = new SearchControls();
        if (roleSearchSubtreeBool) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        NamingEnumeration<SearchResult> results = context.search(this.getLDAPPropertyValue(ROLE_BASE), filter, constraints);
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) continue;
            list = this.addAttributeValues(this.getLDAPPropertyValue(ROLE_NAME), attrs, list);
        }
        return list;
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuffer buf = new StringBuffer(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected boolean bindUser(DirContext context, String dn, String password) throws NamingException {
        boolean isValid = false;
        context.addToEnvironment("java.naming.security.principal", dn);
        context.addToEnvironment("java.naming.security.credentials", password);
        try {
            context.getAttributes("", null);
            isValid = true;
        }
        catch (AuthenticationException e) {
            isValid = false;
            log.debug("Authentication failed for dn=" + dn);
        }
        if (this.isLoginPropertySet(CONNECTION_USERNAME)) {
            context.addToEnvironment("java.naming.security.principal", this.getLDAPPropertyValue(CONNECTION_USERNAME));
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.isLoginPropertySet(CONNECTION_PASSWORD)) {
            context.addToEnvironment("java.naming.security.credentials", this.getLDAPPropertyValue(CONNECTION_PASSWORD));
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
        return isValid;
    }

    private ArrayList<String> addAttributeValues(String attrId, Attributes attrs, ArrayList<String> values) throws NamingException {
        Attribute attr;
        if (attrId == null || attrs == null) {
            return values;
        }
        if (values == null) {
            values = new ArrayList();
        }
        if ((attr = attrs.get(attrId)) == null) {
            return values;
        }
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMore()) {
            String value = (String)e.next();
            values.add(value);
        }
        return values;
    }

    protected DirContext open() throws NamingException {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.getLDAPPropertyValue(INITIAL_CONTEXT_FACTORY));
            if (this.isLoginPropertySet(CONNECTION_USERNAME)) {
                env.put("java.naming.security.principal", this.getLDAPPropertyValue(CONNECTION_USERNAME));
            }
            if (this.isLoginPropertySet(CONNECTION_PASSWORD)) {
                env.put("java.naming.security.credentials", this.getLDAPPropertyValue(CONNECTION_PASSWORD));
            }
            env.put("java.naming.security.protocol", this.getLDAPPropertyValue(CONNECTION_PROTOCOL));
            env.put("java.naming.provider.url", this.getLDAPPropertyValue(CONNECTION_URL));
            env.put("java.naming.security.authentication", this.getLDAPPropertyValue(AUTHENTICATION));
            this.context = new InitialDirContext(env);
        }
        catch (NamingException e) {
            log.error(e);
            throw e;
        }
        return this.context;
    }

    private String getLDAPPropertyValue(String propertyName) {
        for (int i = 0; i < this.config.length; ++i) {
            if (this.config[i].getPropertyName() != propertyName) continue;
            return this.config[i].getPropertyValue();
        }
        return null;
    }

    private boolean isLoginPropertySet(String propertyName) {
        for (int i = 0; i < this.config.length; ++i) {
            if (this.config[i].getPropertyName() != propertyName || this.config[i].getPropertyValue() == null) continue;
            return true;
        }
        return false;
    }
}

