/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_lgt_reg_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_lgt_reg");
    reader.add_event(57, 55, "end", "model_lgt_reg");
    return reader;
}

#include <meta_header.hpp>
 class model_lgt_reg : public prob_grad {
private:
    double CAUCHY_SD;
    double MIN_POW_TREND;
    double MAX_POW_TREND;
    double MIN_SIGMA;
    double MIN_NU;
    double MAX_NU;
    int N;
    int J;
    vector_d y;
    matrix_d xreg;
    double POW_TREND_ALPHA;
    double POW_TREND_BETA;
public:
    model_lgt_reg(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_lgt_reg(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_lgt_reg_namespace::model_lgt_reg";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "CAUCHY_SD", "double", context__.to_vec());
            CAUCHY_SD = double(0);
            vals_r__ = context__.vals_r("CAUCHY_SD");
            pos__ = 0;
            CAUCHY_SD = vals_r__[pos__++];
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "MIN_POW_TREND", "double", context__.to_vec());
            MIN_POW_TREND = double(0);
            vals_r__ = context__.vals_r("MIN_POW_TREND");
            pos__ = 0;
            MIN_POW_TREND = vals_r__[pos__++];
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "MAX_POW_TREND", "double", context__.to_vec());
            MAX_POW_TREND = double(0);
            vals_r__ = context__.vals_r("MAX_POW_TREND");
            pos__ = 0;
            MAX_POW_TREND = vals_r__[pos__++];
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "MIN_SIGMA", "double", context__.to_vec());
            MIN_SIGMA = double(0);
            vals_r__ = context__.vals_r("MIN_SIGMA");
            pos__ = 0;
            MIN_SIGMA = vals_r__[pos__++];
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "MIN_NU", "double", context__.to_vec());
            MIN_NU = double(0);
            vals_r__ = context__.vals_r("MIN_NU");
            pos__ = 0;
            MIN_NU = vals_r__[pos__++];
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "MAX_NU", "double", context__.to_vec());
            MAX_NU = double(0);
            vals_r__ = context__.vals_r("MAX_NU");
            pos__ = 0;
            MAX_NU = vals_r__[pos__++];
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 10;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = vector_d(static_cast<Eigen::VectorXd::Index>(N));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_i_vec_lim__ = N;
            for (size_t i_vec__ = 0; i_vec__ < y_i_vec_lim__; ++i_vec__) {
                y[i_vec__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("xreg", "N", N);
            validate_non_negative_index("xreg", "J", J);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(N,J));
            validate_non_negative_index("xreg", "N", N);
            validate_non_negative_index("xreg", "J", J);
            xreg = matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(J));
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_m_mat_lim__ = N;
            size_t xreg_n_mat_lim__ = J;
            for (size_t n_mat__ = 0; n_mat__ < xreg_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < xreg_m_mat_lim__; ++m_mat__) {
                    xreg(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "POW_TREND_ALPHA", "double", context__.to_vec());
            POW_TREND_ALPHA = double(0);
            vals_r__ = context__.vals_r("POW_TREND_ALPHA");
            pos__ = 0;
            POW_TREND_ALPHA = vals_r__[pos__++];
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "POW_TREND_BETA", "double", context__.to_vec());
            POW_TREND_BETA = double(0);
            vals_r__ = context__.vals_r("POW_TREND_BETA");
            pos__ = 0;
            POW_TREND_BETA = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 4;
            check_greater_or_equal(function__,"CAUCHY_SD",CAUCHY_SD,0);
            current_statement_begin__ = 5;
            current_statement_begin__ = 5;
            current_statement_begin__ = 6;
            check_greater_or_equal(function__,"MIN_SIGMA",MIN_SIGMA,0);
            current_statement_begin__ = 7;
            check_greater_or_equal(function__,"MIN_NU",MIN_NU,1);
            current_statement_begin__ = 7;
            check_greater_or_equal(function__,"MAX_NU",MAX_NU,1);
            current_statement_begin__ = 8;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 9;
            check_greater_or_equal(function__,"J",J,1);
            current_statement_begin__ = 10;
            check_greater_or_equal(function__,"y",y,0);
            current_statement_begin__ = 11;
            current_statement_begin__ = 12;
            check_greater_or_equal(function__,"POW_TREND_ALPHA",POW_TREND_ALPHA,0);
            current_statement_begin__ = 12;
            check_greater_or_equal(function__,"POW_TREND_BETA",POW_TREND_BETA,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 15;
            validate_non_negative_index("regCoef", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 16;
            ++num_params_r__;
            current_statement_begin__ = 17;
            ++num_params_r__;
            current_statement_begin__ = 18;
            ++num_params_r__;
            current_statement_begin__ = 19;
            ++num_params_r__;
            current_statement_begin__ = 20;
            ++num_params_r__;
            current_statement_begin__ = 21;
            ++num_params_r__;
            current_statement_begin__ = 22;
            ++num_params_r__;
            current_statement_begin__ = 23;
            ++num_params_r__;
            current_statement_begin__ = 24;
            ++num_params_r__;
            current_statement_begin__ = 25;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_lgt_reg() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("regCoef")))
            throw std::runtime_error("variable regCoef missing");
        vals_r__ = context__.vals_r("regCoef");
        pos__ = 0U;
        validate_non_negative_index("regCoef", "J", J);
        context__.validate_dims("initialization", "regCoef", "vector_d", context__.to_vec(J));
        vector_d regCoef(static_cast<Eigen::VectorXd::Index>(J));
        for (int j1__ = 0U; j1__ < J; ++j1__)
            regCoef(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(regCoef);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable regCoef: ") + e.what());
        }

        if (!(context__.contains_r("nu")))
            throw std::runtime_error("variable nu missing");
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(MIN_NU,MAX_NU,nu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nu: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("levSm")))
            throw std::runtime_error("variable levSm missing");
        vals_r__ = context__.vals_r("levSm");
        pos__ = 0U;
        context__.validate_dims("initialization", "levSm", "double", context__.to_vec());
        double levSm(0);
        levSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,levSm);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable levSm: ") + e.what());
        }

        if (!(context__.contains_r("bSm")))
            throw std::runtime_error("variable bSm missing");
        vals_r__ = context__.vals_r("bSm");
        pos__ = 0U;
        context__.validate_dims("initialization", "bSm", "double", context__.to_vec());
        double bSm(0);
        bSm = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,bSm);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable bSm: ") + e.what());
        }

        if (!(context__.contains_r("powx")))
            throw std::runtime_error("variable powx missing");
        vals_r__ = context__.vals_r("powx");
        pos__ = 0U;
        context__.validate_dims("initialization", "powx", "double", context__.to_vec());
        double powx(0);
        powx = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,powx);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable powx: ") + e.what());
        }

        if (!(context__.contains_r("bInit")))
            throw std::runtime_error("variable bInit missing");
        vals_r__ = context__.vals_r("bInit");
        pos__ = 0U;
        context__.validate_dims("initialization", "bInit", "double", context__.to_vec());
        double bInit(0);
        bInit = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(bInit);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable bInit: ") + e.what());
        }

        if (!(context__.contains_r("powTrendBeta")))
            throw std::runtime_error("variable powTrendBeta missing");
        vals_r__ = context__.vals_r("powTrendBeta");
        pos__ = 0U;
        context__.validate_dims("initialization", "powTrendBeta", "double", context__.to_vec());
        double powTrendBeta(0);
        powTrendBeta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,powTrendBeta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable powTrendBeta: ") + e.what());
        }

        if (!(context__.contains_r("coefTrend")))
            throw std::runtime_error("variable coefTrend missing");
        vals_r__ = context__.vals_r("coefTrend");
        pos__ = 0U;
        context__.validate_dims("initialization", "coefTrend", "double", context__.to_vec());
        double coefTrend(0);
        coefTrend = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(coefTrend);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable coefTrend: ") + e.what());
        }

        if (!(context__.contains_r("offsetSigma")))
            throw std::runtime_error("variable offsetSigma missing");
        vals_r__ = context__.vals_r("offsetSigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "offsetSigma", "double", context__.to_vec());
        double offsetSigma(0);
        offsetSigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(MIN_SIGMA,offsetSigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable offsetSigma: ") + e.what());
        }

        if (!(context__.contains_r("locTrendFract")))
            throw std::runtime_error("variable locTrendFract missing");
        vals_r__ = context__.vals_r("locTrendFract");
        pos__ = 0U;
        context__.validate_dims("initialization", "locTrendFract", "double", context__.to_vec());
        double locTrendFract(0);
        locTrendFract = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,locTrendFract);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable locTrendFract: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  regCoef;
            (void) regCoef;  // dummy to suppress unused var warning
            if (jacobian__)
                regCoef = in__.vector_constrain(J,lp__);
            else
                regCoef = in__.vector_constrain(J);

            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lub_constrain(MIN_NU,MAX_NU,lp__);
            else
                nu = in__.scalar_lub_constrain(MIN_NU,MAX_NU);

            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0,lp__);
            else
                sigma = in__.scalar_lb_constrain(0);

            local_scalar_t__ levSm;
            (void) levSm;  // dummy to suppress unused var warning
            if (jacobian__)
                levSm = in__.scalar_lub_constrain(0,1,lp__);
            else
                levSm = in__.scalar_lub_constrain(0,1);

            local_scalar_t__ bSm;
            (void) bSm;  // dummy to suppress unused var warning
            if (jacobian__)
                bSm = in__.scalar_lub_constrain(0,1,lp__);
            else
                bSm = in__.scalar_lub_constrain(0,1);

            local_scalar_t__ powx;
            (void) powx;  // dummy to suppress unused var warning
            if (jacobian__)
                powx = in__.scalar_lub_constrain(0,1,lp__);
            else
                powx = in__.scalar_lub_constrain(0,1);

            local_scalar_t__ bInit;
            (void) bInit;  // dummy to suppress unused var warning
            if (jacobian__)
                bInit = in__.scalar_constrain(lp__);
            else
                bInit = in__.scalar_constrain();

            local_scalar_t__ powTrendBeta;
            (void) powTrendBeta;  // dummy to suppress unused var warning
            if (jacobian__)
                powTrendBeta = in__.scalar_lub_constrain(0,1,lp__);
            else
                powTrendBeta = in__.scalar_lub_constrain(0,1);

            local_scalar_t__ coefTrend;
            (void) coefTrend;  // dummy to suppress unused var warning
            if (jacobian__)
                coefTrend = in__.scalar_constrain(lp__);
            else
                coefTrend = in__.scalar_constrain();

            local_scalar_t__ offsetSigma;
            (void) offsetSigma;  // dummy to suppress unused var warning
            if (jacobian__)
                offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA,lp__);
            else
                offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA);

            local_scalar_t__ locTrendFract;
            (void) locTrendFract;  // dummy to suppress unused var warning
            if (jacobian__)
                locTrendFract = in__.scalar_lub_constrain(0,1,lp__);
            else
                locTrendFract = in__.scalar_lub_constrain(0,1);


            // transformed parameters
            current_statement_begin__ = 28;
            local_scalar_t__ powTrend;
            (void) powTrend;  // dummy to suppress unused var warning

            stan::math::initialize(powTrend, DUMMY_VAR__);
            stan::math::fill(powTrend,DUMMY_VAR__);
            current_statement_begin__ = 29;
            validate_non_negative_index("l", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  l(static_cast<Eigen::VectorXd::Index>(N));
            (void) l;  // dummy to suppress unused var warning

            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l,DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
            (void) b;  // dummy to suppress unused var warning

            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b,DUMMY_VAR__);
            current_statement_begin__ = 31;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  r(static_cast<Eigen::VectorXd::Index>(N));
            (void) r;  // dummy to suppress unused var warning

            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r,DUMMY_VAR__);


            current_statement_begin__ = 33;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "xreg"),regCoef), 
                        "assigning variable r");
            current_statement_begin__ = 34;
            stan::model::assign(l, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        get_base1(y,1,"y",1), 
                        "assigning variable l");
            current_statement_begin__ = 34;
            stan::model::assign(b, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        bInit, 
                        "assigning variable b");
            current_statement_begin__ = 35;
            stan::math::assign(powTrend, (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) + MIN_POW_TREND));
            current_statement_begin__ = 37;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 38;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "xreg"),regCoef), 
                            "assigning variable r");
                current_statement_begin__ = 39;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(((levSm * get_base1(y,t,"y",1)) + ((1 - levSm) * get_base1(l,(t - 1),"l",1)))), 
                            "assigning variable l");
                current_statement_begin__ = 40;
                stan::model::assign(b, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(((bSm * (get_base1(l,t,"l",1) - get_base1(l,(t - 1),"l",1))) + ((1 - bSm) * get_base1(b,(t - 1),"b",1)))), 
                            "assigning variable b");
            }

            // validate transformed parameters
            if (stan::math::is_uninitialized(powTrend)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: powTrend";
                throw std::runtime_error(msg__.str());
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(l(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: l" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(b(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(r(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: r" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 28;
            check_greater_or_equal(function__,"powTrend",powTrend,MIN_POW_TREND);
            check_less_or_equal(function__,"powTrend",powTrend,MAX_POW_TREND);
            current_statement_begin__ = 29;
            check_greater_or_equal(function__,"l",l,0);
            current_statement_begin__ = 30;
            current_statement_begin__ = 31;

            // model body

            current_statement_begin__ = 44;
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, CAUCHY_SD));
            if (sigma < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-cauchy_ccdf_log(0, 0, CAUCHY_SD));
            current_statement_begin__ = 45;
            lp_accum__.add(cauchy_log<propto__>(offsetSigma, MIN_SIGMA, CAUCHY_SD));
            if (offsetSigma < MIN_SIGMA) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-cauchy_ccdf_log(MIN_SIGMA, MIN_SIGMA, CAUCHY_SD));
            current_statement_begin__ = 46;
            lp_accum__.add(cauchy_log<propto__>(coefTrend, 0, CAUCHY_SD));
            current_statement_begin__ = 47;
            lp_accum__.add(beta_log<propto__>(powTrendBeta, POW_TREND_ALPHA, POW_TREND_BETA));
            current_statement_begin__ = 48;
            lp_accum__.add(normal_log<propto__>(bInit, 0, CAUCHY_SD));
            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(regCoef, 0, 1));
            current_statement_begin__ = 51;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 52;
                lp_accum__.add(student_t_log<propto__>(get_base1(y,t,"y",1), nu, (((get_base1(l,(t - 1),"l",1) + (coefTrend * pow(get_base1(l,(t - 1),"l",1),powTrend))) + (locTrendFract * get_base1(b,(t - 1),"b",1))) + get_base1(r,t,"r",1)), ((sigma * pow(get_base1(l,(t - 1),"l",1),powx)) + offsetSigma)));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("regCoef");
        names__.push_back("nu");
        names__.push_back("sigma");
        names__.push_back("levSm");
        names__.push_back("bSm");
        names__.push_back("powx");
        names__.push_back("bInit");
        names__.push_back("powTrendBeta");
        names__.push_back("coefTrend");
        names__.push_back("offsetSigma");
        names__.push_back("locTrendFract");
        names__.push_back("powTrend");
        names__.push_back("l");
        names__.push_back("b");
        names__.push_back("r");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_lgt_reg_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d regCoef = in__.vector_constrain(J);
        double nu = in__.scalar_lub_constrain(MIN_NU,MAX_NU);
        double sigma = in__.scalar_lb_constrain(0);
        double levSm = in__.scalar_lub_constrain(0,1);
        double bSm = in__.scalar_lub_constrain(0,1);
        double powx = in__.scalar_lub_constrain(0,1);
        double bInit = in__.scalar_constrain();
        double powTrendBeta = in__.scalar_lub_constrain(0,1);
        double coefTrend = in__.scalar_constrain();
        double offsetSigma = in__.scalar_lb_constrain(MIN_SIGMA);
        double locTrendFract = in__.scalar_lub_constrain(0,1);
            for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(regCoef[k_0__]);
            }
        vars__.push_back(nu);
        vars__.push_back(sigma);
        vars__.push_back(levSm);
        vars__.push_back(bSm);
        vars__.push_back(powx);
        vars__.push_back(bInit);
        vars__.push_back(powTrendBeta);
        vars__.push_back(coefTrend);
        vars__.push_back(offsetSigma);
        vars__.push_back(locTrendFract);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 28;
            local_scalar_t__ powTrend;
            (void) powTrend;  // dummy to suppress unused var warning

            stan::math::initialize(powTrend, DUMMY_VAR__);
            stan::math::fill(powTrend,DUMMY_VAR__);
            current_statement_begin__ = 29;
            validate_non_negative_index("l", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  l(static_cast<Eigen::VectorXd::Index>(N));
            (void) l;  // dummy to suppress unused var warning

            stan::math::initialize(l, DUMMY_VAR__);
            stan::math::fill(l,DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("b", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  b(static_cast<Eigen::VectorXd::Index>(N));
            (void) b;  // dummy to suppress unused var warning

            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b,DUMMY_VAR__);
            current_statement_begin__ = 31;
            validate_non_negative_index("r", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  r(static_cast<Eigen::VectorXd::Index>(N));
            (void) r;  // dummy to suppress unused var warning

            stan::math::initialize(r, DUMMY_VAR__);
            stan::math::fill(r,DUMMY_VAR__);


            current_statement_begin__ = 33;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "xreg"),regCoef), 
                        "assigning variable r");
            current_statement_begin__ = 34;
            stan::model::assign(l, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        get_base1(y,1,"y",1), 
                        "assigning variable l");
            current_statement_begin__ = 34;
            stan::model::assign(b, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        bInit, 
                        "assigning variable b");
            current_statement_begin__ = 35;
            stan::math::assign(powTrend, (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) + MIN_POW_TREND));
            current_statement_begin__ = 37;
            for (int t = 2; t <= N; ++t) {

                current_statement_begin__ = 38;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "xreg"),regCoef), 
                            "assigning variable r");
                current_statement_begin__ = 39;
                stan::model::assign(l, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(((levSm * get_base1(y,t,"y",1)) + ((1 - levSm) * get_base1(l,(t - 1),"l",1)))), 
                            "assigning variable l");
                current_statement_begin__ = 40;
                stan::model::assign(b, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            stan::model::deep_copy(((bSm * (get_base1(l,t,"l",1) - get_base1(l,(t - 1),"l",1))) + ((1 - bSm) * get_base1(b,(t - 1),"b",1)))), 
                            "assigning variable b");
            }

            // validate transformed parameters
            current_statement_begin__ = 28;
            check_greater_or_equal(function__,"powTrend",powTrend,MIN_POW_TREND);
            check_less_or_equal(function__,"powTrend",powTrend,MAX_POW_TREND);
            current_statement_begin__ = 29;
            check_greater_or_equal(function__,"l",l,0);
            current_statement_begin__ = 30;
            current_statement_begin__ = 31;

            // write transformed parameters
            if (include_tparams__) {
        vars__.push_back(powTrend);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(l[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(b[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(r[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_lgt_reg";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "regCoef" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "levSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powx";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bInit";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powTrendBeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "coefTrend";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "offsetSigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "locTrendFract";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "powTrend";
            param_names__.push_back(param_name_stream__.str());
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "regCoef" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "levSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bSm";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powx";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bInit";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "powTrendBeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "coefTrend";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "offsetSigma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "locTrendFract";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "powTrend";
            param_names__.push_back(param_name_stream__.str());
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "l" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
    }

}; // model

}

typedef model_lgt_reg_namespace::model_lgt_reg stan_model;


#endif
