\name{histCluster}
\alias{histCluster}
\title{Histogram of a class [\code{\linkS4class{MixmodResults}}]}
\usage{
  histCluster(x, data, variables = colnames(data),
    xlab = rep("", length(variables)),
    main = paste("Histogram of", variables), ...)
}
\arguments{
  \item{x}{an object of class
  [\code{\linkS4class{MixmodResults}}]}

  \item{data}{a vector, matrix or data frame containing a
  quantitative data set.}

  \item{variables}{list of variables names to compute a
  histogram. All variables from data by default.}

  \item{xlab}{a list of title for the x axis. xlab must
  have the same length than variables.}

  \item{main}{a list of title for the histogram. main must
  have the same length than variables.}

  \item{...}{further arguments passed to or from other
  methods}
}
\description{
  Histograms of data object using parameters from a
  [\code{\linkS4class{MixmodResults}}] to plot densities.
}
\details{
  Data with the density of each cluster and the mixture
  density are drawn for each variable.
}
\examples{
data(geyser)
  xem1 <- mixmodCluster(geyser,3)
  histCluster(xem1["bestResult"], geyser)
}
\seealso{
  \code{\link{hist}}
}

