% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R, R/Model.R, R/MultinomialParameter.R,
%   R/GaussianParameter.R, R/CompositeParameter.R, R/MixmodResults.R,
%   R/Mixmod.R, R/Strategy.R, R/MixmodCluster.R, R/MixmodDAResults.R,
%   R/MixmodLearn.R, R/MixmodPredict.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,Model-method}
\alias{show,MultinomialParameter-method}
\alias{show,GaussianParameter-method}
\alias{show,CompositeParameter-method}
\alias{show,MixmodResults-method}
\alias{show,Mixmod-method}
\alias{show,Strategy-method}
\alias{show,MixmodCluster-method}
\alias{show,MixmodDAResults-method}
\alias{show,MixmodLearn-method}
\alias{show,MixmodPredict-method}
\title{Show description of a Rmixmod class to standard output.}
\usage{
\S4method{show}{Model}(object)

\S4method{show}{MultinomialParameter}(object)

\S4method{show}{GaussianParameter}(object)

\S4method{show}{CompositeParameter}(object)

\S4method{show}{MixmodResults}(object)

\S4method{show}{Mixmod}(object)

\S4method{show}{Strategy}(object)

\S4method{show}{MixmodCluster}(object)

\S4method{show}{MixmodDAResults}(object)

\S4method{show}{MixmodLearn}(object)

\S4method{show}{MixmodPredict}(object)
}
\arguments{
\item{object}{a Rmixmod object: a \code{\linkS4class{Strategy}}, a \code{\linkS4class{Model}}, a \code{\linkS4class{GaussianParameter}}, a \code{\linkS4class{MultinomialParameter}}, a \code{\linkS4class{MixmodResults}}, a \code{\linkS4class{MixmodCluster}}, a \code{\linkS4class{MixmodLearn}} or a \code{\linkS4class{MixmodPredict}}.}
}
\value{
NULL. Prints to standard out.
}
\description{
Show description of a Rmixmod class to standard output.
}
\examples{
  ## for strategy
  strategy <- mixmodStrategy()
  show(strategy)

  ## for Gaussian models
  gmodel <- mixmodGaussianModel()
  show(gmodel)
  ## for multinomial models
  mmodel <- mixmodMultinomialModel()
  show(mmodel)

  ## for clustering
  data(geyser)
  xem <- mixmodCluster(geyser,3)
  show(xem)
  ## for Gaussian parameters
  show(xem["bestResult"]["parameters"])

  ## for discriminant analysis
  # start by extract 10 observations from iris data set
  iris.partition<-sample(1:nrow(iris),10)
  # then run a mixmodLearn() analysis without those 10 observations
  learn<-mixmodLearn(iris[-iris.partition,1:4], iris$Species[-iris.partition])
  # create a MixmodPredict to predict those 10 observations
  prediction <- mixmodPredict(data=iris[iris.partition,1:4], classificationRule=learn["bestResult"])
  # show results
  show(prediction)

}
\seealso{
\code{\link{show}}
}
