% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EKC.R
\name{EKC}
\alias{EKC}
\alias{ekc}
\title{Empirical Kaiser Criterion (EKC)}
\usage{
EKC(.data = NULL, n = NULL, nv = NULL, lowest.eig = 1, ...)
}
\arguments{
\item{.data}{a data frame, a numeric matrix, covariance matrix or correlation matrix from which to determine the number of factors.}

\item{n}{the number of cases (subjects, participants, or units) if a covariance matrix is supplied in \code{.data}.}

\item{nv}{the number of variables if the critical values are required.}

\item{lowest.eig}{minimal eigenvalues to retain. Default is Kaiser's suggestion of 1.}

\item{...}{further argument for \code{cor_nest()}.}
}
\value{
The number of factors to retain or the crititical eigenvalues.
}
\description{
Empirical Kaiser Criterion (EKC)
}
\examples{
EKC(ex_4factors_corr, n = 42)
}
\references{
Braeken, J., & van Assen, M. A. L. M. (2017). An empirical Kaiser criterion. \emph{Psychological Methods}, \emph{22}(3), 450–466. \doi{10.1037/met0000074}
}
