% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{existsCtryNlData}
\alias{existsCtryNlData}
\title{Check if VIIRS nightlight stats exist locally}
\usage{
existsCtryNlData(ctryCode = NULL, admLevel, nlTypes, nlPeriods, nlStats,
  gadmVersion = pkgOptions("gadmVersion"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{character The ISO3 code of the country}

\item{admLevel}{character string The country admin level of interest}

\item{nlTypes}{character The nlTypes}

\item{nlPeriods}{character The nlPeriods}

\item{nlStats}{character The nlStats to check for}

\item{gadmVersion}{The GADM version to use}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
TRUE/FALSE
}
\description{
Check if VIIRS nightlight data for the country exists in the country 
    nightlight data file. First checks if the country nightlight data
    file exists.
}
\examples{
Rnightlights:::existsCtryNlData("KEN", "KEN_adm0", "VIIRS.M","201401", "sum")

}
