% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{allValid}
\alias{allValid}
\title{Check if a vector/list of values given is valid as per the given validation function}
\usage{
allValid(testData, testFun, ...)
}
\arguments{
\item{testData}{The list/vector of values to validate}

\item{testFun}{The validation function to test each value of testData against}

\item{...}{Other parameters to pass on to the testFun}
}
\value{
TRUE/FALSE
}
\description{
Check if a vector/list of values given is valid as per the given 
    validation function. The function will also print a warning 
    showing the values that are invalid. One can stop the warning 
    being printed by wrapping the function in the 
    \code{suppressWarnings} function.
}
\examples{

\donttest{
  Rnightlights:::allValid(c("KEZ", "UGA", "RWA", "TZA"), Rnightlights:::validCtryCodes)
}
 
\donttest{
  Rnightlights:::allValid(c("2012", "2015"), validNlPeriods, "OLS.Y")
}

}
