% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{createCtryNlDataDF}
\alias{createCtryNlDataDF}
\title{Initiates the country nightlight dataframe with the country admin level 
    data read from the polygon}
\usage{
createCtryNlDataDF(ctryCode = NULL, admLevel,
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{the ISO3 code of the country}

\item{admLevel}{The country admin level of interest}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
dataframe with the country admin level data
}
\description{
Initiates the country admin level nightlight dataframe with the country 
    admin level data read from the polygon. This includes admin levels, 
    level names and area
}
\examples{
\dontrun{
initCtryNlData <- Rnightlights:::createCtryNlDataDF("KEN")
 #returns a data frame
}


}
