% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nightlights.R
\name{getCtryRasterOutputFnamePath}
\alias{getCtryRasterOutputFnamePath}
\title{Get the full path to the file where the cropped VIIRS country raster is stored.}
\usage{
getCtryRasterOutputFnamePath(ctryCode, nlType, configName,
  multiTileStrategy = pkgOptions("multiTileStrategy"),
  multiTileMergeFun = pkgOptions("multiTileMergeFun"),
  removeGasFlares = pkgOptions("removeGasFlares"), nlPeriod,
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{the ctryCode of interest}

\item{nlType}{the nlType of interest}

\item{configName}{character the type of raster being processed}

\item{multiTileStrategy}{character How to handle multiple tiles per nlPeriod}

\item{multiTileMergeFun}{character The function to use to merge tiles}

\item{removeGasFlares}{logical Whether to perform gas flare removal pre-processing}

\item{nlPeriod}{the nlPeriod of interest}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{The path to a custom polygon as an alternative
to using GADM polygons}
}
\value{
Character full path to the cropped VIIRS country raster for a country and a given year and month
}
\description{
Get the full path to the file where the cropped VIIRS country raster is stored. This file is created
    when processing the country before extracting the data. It can be used to re-process a country much faster
}
\examples{
\dontrun{
getCtryRasterOutputFnamePath("KEN","VIIRS.M", "201412")
}

#export for exploreData() shiny app
}
