% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-input-and-settings.R
\name{check_setup}
\alias{check_setup}
\title{Prints summary of \code{"RoBTT"} ensemble implied by the specified priors}
\usage{
check_setup(
  prior_delta = prior(distribution = "cauchy", parameters = list(location = 0, scale =
    sqrt(2)/2)),
  prior_rho = prior(distribution = "beta", parameters = list(alpha = 1, beta = 1)),
  prior_nu = prior(distribution = "exp", parameters = list(rate = 1)),
  prior_delta_null = prior(distribution = "spike", parameters = list(location = 0)),
  prior_rho_null = prior(distribution = "spike", parameters = list(location = 0.5)),
  prior_nu_null = NULL,
  likelihood = c("normal", if (!is.null(prior_nu)) "t"),
  models = FALSE,
  silent = FALSE
)
}
\arguments{
\item{prior_delta}{prior distributions for the effect size \code{delta} parameter
that will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "Cauchy", parameters = list(location = 0, scale = sqrt(2)/2))}.}

\item{prior_rho}{prior distributions for the precision allocation \code{rho} parameter
that will be treated as belonging to the alternative hypothesis. Defaults to \code{
prior(distribution = "beta", parameters = list(alpha = 1, beta = 1))}.}

\item{prior_nu}{prior distribution for the degrees of freedom + 2 \code{nu}
parameter that will be treated as belonging to the alternative hypothesis.
Defaults to \code{prior(distribution = "exp", parameters = list(rate = 1))}.}

\item{prior_delta_null}{prior distribution for the \code{delta} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0 (
\code{prior(distribution = "point", parameters = list(location = 0))}).}

\item{prior_rho_null}{prior distribution for the \code{rho} parameter that
will be treated as belonging to the null hypothesis. Defaults to point distribution
with location at 0.5 (
\code{prior(distribution = "point", parameters = list(location = 0.5))}).}

\item{prior_nu_null}{prior distribution for the \code{nu} parameter
that will be treated as belonging to the null hypothesis. Defaults to NULL (
\code{NULL}, i.e., normal distribution).}

\item{likelihood}{types of likelihood to be used. Defaults to \code{c("normal", "t")}
for a normal and t likelihoods.}

\item{models}{should the models' details be printed.}

\item{silent}{do not print the results.}
}
\value{
\code{check_setup} invisibly returns list of summary tables.
}
\description{
\code{check_setup} prints summary of \code{"RoBTT"} ensemble
implied by the specified prior distributions. It is useful for checking
the ensemble configuration prior to fitting all of the models.
}
\seealso{
\code{\link[=RoBTT]{RoBTT()}}
}
