% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainIntBoost.R
\name{tuneandtrainIntBoost}
\alias{tuneandtrainIntBoost}
\title{Tune and Train Internal Boosting}
\usage{
tuneandtrainIntBoost(data, mstop_seq = seq(5, 1000, by = 5), nu = 0.1)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{mstop_seq}{A numeric vector of boosting iterations to be evaluated. Default is a sequence 
from 5 to 1000 with a step of 5.}

\item{nu}{A numeric value for the learning rate. Default is 0.1.}
}
\value{
A list containing the best number of boosting iterations (`best_mstop`), 
  the final Boosting classifier model (`best_model`) and the AUC on the training data (`final_auc`).
}
\description{
This function tunes and trains a Boosting classifier using the \code{mboost} package. The function 
evaluates a sequence of boosting iterations on the training dataset using internal cross-validation 
and selects the best model based on the Area Under the Curve (AUC).
}
\details{
This function performs K-fold cross-validation on the training dataset, where the number of boosting 
iterations (\code{mstop}) is tuned to maximize the AUC. The optimal number of boosting iterations is selected, 
and the final model is trained on the entire training dataset.
}
\examples{
\donttest{
# Load sample data
data(sample_data_train)

# Example usage
mstop_seq <- seq(5, 5000, by = 5)
result <- tuneandtrainIntBoost(sample_data_train, mstop_seq, nu = 0.1)
result$best_mstop
result$best_model
result$final_auc
}
}
