\name{summary.RuleSetFRST}
\alias{summary.RuleSetFRST}
\title{The summary function of rules based on FRST}
\usage{
\method{summary}{RuleSetFRST}(object, ...)
}
\arguments{
  \item{object}{a \code{"RuleSetFRST"} object. See
  \code{\link{RI.hybridFS.FRST}} and
  \code{\link{RI.GFRS.FRST}}.}

  \item{...}{the other parameters.}
}
\value{
a description that contains the following information:
\itemize{ \item The type of the considered model. \item The
type of the considered method. \item The type of the
considered task. \item The type of similarity. \item The
type of triangular norm. \item The names of attributes and
their type (whether nominal or not). \item The interval of
the data. \item the variance values of the data. \item The
rules. Every rule constitutes two parts which are IF and
THEN parts.  For example, \code{"IF pres is around 90 and
preg is around 8 THEN class is 2"}.  See
\code{\link{RI.GFRS.FRST}}. }
}
\description{
This function enables the output of a summary of the rule
induction methods.
}
\examples{
###########################################################
## Example 1: Regression problem
###########################################################
data(RoughSetData)
decision.table <- RoughSetData$housing7.dt

control <- list(type.aggregation = c("t.tnorm", "lukasiewicz"), type.relation =
                c("tolerance", "eq.3"), t.implicator = "lukasiewicz")
res.1 <- RI.hybridFS.FRST(decision.table, control)

summary(res.1)
###########################################################
## Example 2: Classification problem
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$pima7.dt

control <- list(type.aggregation = c("t.tnorm", "lukasiewicz"), type.relation =
                c("tolerance", "eq.3"), t.implicator = "lukasiewicz")
res.2 <- RI.hybridFS.FRST(decision.table, control)

summary(res.2)
}

