% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/BasicRoughSets.R
\name{BC.LU.approximation.RST}
\alias{BC.LU.approximation.RST}
\title{Computation of lower and upper approximations of decision classes}
\usage{
BC.LU.approximation.RST(decision.table, IND)
}
\arguments{
\item{decision.table}{an object inheriting from the \code{"DecisionTable"} class, which represents a decision system.
See \code{\link{SF.asDecisionTable}}.}

\item{IND}{an object inheriting from the \code{"IndiscernibilityRelation"} class, which represents indiscernibility clasees in the data.}
}
\value{
An object of a class \code{"LowerUpperApproximation"} which is a list with the following components:
        \itemize{
         \item \code{lower.approximation}: a list with indices of data instances included in lower approximations of decision classes.
         \item \code{upper.approximation}: a list with indices of data instances included in upper approximations of decision classes.
         \item \code{type.model}: a character vector identifying the type of model which was used.
               In this case, it is \code{"RST"} which means the rough set theory.
         }
}
\description{
This function implements a fundamental part of RST: computation of lower and upper approximations.
The lower and upper approximations determine whether the objects can be certainty or possibly classified
to a particular decision class on the basis of available knowledge.
}
\details{
This function can be used as a basic building block for development of other RST-based methods.
A more detailed explanation of this notion can be found in \code{\link{A.Introduction-RoughSets}}.
}
\examples{
#######################################
data(RoughSetData)
hiring.data <- RoughSetData$hiring.dt

## We select a single attribute for computation of indiscernibility classes:
A <- c(2)

## Compute the indiscernibility classes:
IND.A <- BC.IND.relation.RST(hiring.data, feature.set = A)

## Compute the lower and upper approximations:
roughset <- BC.LU.approximation.RST(hiring.data, IND.A)
roughset
}
\author{
Andrzej Janusz
}
\references{
Z. Pawlak, "Rough Sets", International Journal of Computer and Information Sciences,
vol. 11, no. 5, p. 341 - 356 (1982).
}
\seealso{
\code{\link{BC.IND.relation.RST}}, \code{\link{BC.LU.approximation.FRST}}
}

