% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_table.R
\name{create_table}
\alias{create_table}
\title{create_table}
\usage{
create_table(
  df = NULL,
  title = NULL,
  subtitle = NULL,
  container_width_px = NULL,
  container_height_px = NULL,
  rowname_col = NULL,
  col_label_lst = NULL,
  col_width_lst = NULL,
  header_line = FALSE,
  caption = NULL,
  source_note = NULL,
  hor_scroll_bar = FALSE,
  ver_scroll_bar = FALSE,
  decimals_lst = NULL,
  footnote_title = NULL,
  footnote_col_head_lst = NULL,
  footnote_body_lst = NULL
)
}
\arguments{
\item{df}{A data.frame from which to display a table.}

\item{title}{A string that sets the table's title. The string can contain R markdown/html style syntax.}

\item{subtitle}{A string that sets the table's subtitle. The string can contain R markdown/html style syntax.}

\item{container_width_px}{A numeric that sets the overall container width in pixels.}

\item{container_height_px}{A numeric that sets the overall container height in pixels.}

\item{rowname_col}{The column name from 'df' to use as row captions to be placed
in the display table stub.}

\item{col_label_lst}{A list that resets the table's column labels. The list's key is the old label
and the value is the new label. Initially the old labels will be 'df's column names.}

\item{col_width_lst}{A list that sets the table's column widths. The list's key is a column's index
number and value is the column width in pixels. Both the key and value are strings.}

\item{header_line}{A logical which if TRUE will place a bold, thick line between the header row and table body.}

\item{caption}{A string that sets the table caption which appears above the title
to use as cross-referencing in R Markdown/Quarto document. The string can contain R markdown/html style syntax.}

\item{source_note}{A string located at the bottom of the table that notes the table's source.
The string can contain R markdown/html style syntax.}

\item{hor_scroll_bar}{A logical that controls the appearance of the horizontal scroll bar.}

\item{ver_scroll_bar}{A logical that controls the appearance of the vertical scroll bar.}

\item{decimals_lst}{A list that describes the decimals for one or more table columns. The list should
  have the following key-value pairs:
\enumerate{
  \item cols = (an integer vector of column indices from 'df')
  \item decimal = (an integer that defines the number of decimals for the column(s))
}}

\item{footnote_title}{A string at the bottom of the table that footnotes the table's title.}

\item{footnote_col_head_lst}{A list that describes the text/location of a footnote for column headings.
  The list should have the following key-value pairs:
\enumerate{
  \item footnote = (the footnote text to be displayed at the bottom of the table)
  \item col = (an integer vector setting the footnote's column heading index location's)
}}

\item{footnote_body_lst}{A list that describes the text/location of a footnote within the body of the table.
  The list should have the following key-value pairs:
\enumerate{
  \item footnote = (the footnote text to be displayed at the bottom of the table)
  \item col = (an integer vector setting the footnote's column index location's)
  \item row = (an integer vector setting the footnote's row index location's)
}}
}
\value{
A \code{gt} object of class "gt_tbl" which can be further modified.
}
\description{
Function wraps the gt package for creating tables from a data.frame object.
  Function incorporates the \href{https://cran.r-project.org/package=gt}{gt}
  package to create tables primarily for R Markdown/Quarto documents.  The function offers a
  quick alternative if just limited styling and formatting are required.
}
\examples{
library(gt)
library(glue)
library(purrr)
library(RplotterPkg)

RplotterPkg::create_table(
  df = RplotterPkg::people,
  container_width_px = 500,
  col_label_lst = list(
    col_0 = "ID",
    col_1 = "First Name",
    col_2 = "Last Name",
    col_3 = "Age",
    col_4 = "Address",
    col_5 = "Spouse"
  ),
  decimals_lst = list(
    cols = 4,
    decimal = 0
  ),
  rowname_col = "col_0",
  source_note = "Source: *Chardon City Directory*",
  footnote_title = "Employees are current",
  footnote_col_head_lst = list(
    footnote = "As reported on their job application",
    col = c(2,3)
  ),
  footnote_body_lst = list(
    footnote = "Age is approximated",
    col = 4,
    row = c(1,2)
  )
)

}
