% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_management.R
\name{as_cov_names}
\alias{as_cov_names}
\title{Re-label alternative specific covariates}
\usage{
as_cov_names(choice_data, cov, alternatives)
}
\arguments{
\item{choice_data}{A \code{data.frame} of choice data in wide format, i.e. each row represents
one choice occasion.}

\item{cov}{A character vector of the names of alternative specific covariates in
\code{choice_data}.}

\item{alternatives}{A (character or numeric) vector of the alternative names.}
}
\value{
The \code{choice_data} input with updated column names.
}
\description{
In {RprobitB}, alternative specific covariates must be named in the format
\code{"<covariate>_<alternative>"}. This convenience function generates
the format for a given \code{choice_data} set.
}
\examples{
data("Electricity", package = "mlogit")
cov <- c("pf","cl","loc","wk","tod","seas")
alternatives <- 1:4
colnames(Electricity)
Electricity <- as_cov_names(Electricity, cov, alternatives)
colnames(Electricity)

}
