% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel_colms.R
\name{relabel_colms}
\alias{relabel_colms}
\title{Relabel columns to match the selection table format}
\usage{
relabel_colms(X, extra.cols.name = NULL, extra.cols.new.name = NULL, 
khz.to.hz = FALSE, hz.to.khz = FALSE, waveform = FALSE)
}
\arguments{
\item{X}{Data frame imported from Raven.}

\item{extra.cols.name}{Character vector with the names of additional columns to be relabeled. Default is \code{NULL}.
'extra.cols.new.name' must also be provided.}

\item{extra.cols.new.name}{Character vector with the new names for the additional columns to be relabeled. 
Default is \code{NULL}. 'extra.cols.name' must also be provided.}

\item{khz.to.hz}{Logical. Controls if frequency variables ('top.freq' and 'bottom.freq') should be converted from kHz 
(the unit used by other bioacoustic analysis R packages like \code{\link{warbleR}}) to Hz (the unit used by Raven). 
Default is \code{FALSE}.}

\item{hz.to.khz}{Logical. Controls if frequency variables ('top.freq' and 'bottom.freq') should be converted from Hz 
(the unit used by other bioacoustic analysis R packages like Raven) to kHz (the unit used by \code{\link{warbleR}}). 
Default is \code{FALSE}. Ignored if 'kHz.to.hz' is \code{TRUE}.}

\item{waveform}{Logical to control if 'waveform' related data should be included (this data is typically duplicated in 'spectrogram' data).  Default is \code{FALSE} (not to include it).}
}
\value{
The function returns the input data frame with new column names for time and frequency 'coordinates' and sound files and selections.
}
\description{
\code{ relabel_colms} relabels columns to match the selection table format (as in the R package \code{\link{warbleR}})
}
\details{
This function relabels columns to match the selection table format to match then ones used by other bioacoustic analysis R packages like \code{\link{warbleR}}.
}
\examples{

# Load data
data(selection_files)

#save 'Raven' selection tables in the temporary directory 
writeLines(selection_files[[5]], con = file.path(tempdir(), names(selection_files)[5]))

\donttest{ 
#'# import data to R
rvn.dat <- imp_raven(all.data = TRUE, path = tempdir()) 

names(rvn.dat)

# Select data for a single sound file
rvn.dat2 <-  relabel_colms(rvn.dat)

names(rvn.dat2)

# plus 1 additional column
rvn.dat2 <-  relabel_colms(rvn.dat, extra.cols.name = "selec.file", "Raven selection file")

names(rvn.dat2)

# plus 2 additional column 
rvn.dat2 <- relabel_colms(rvn.dat, extra.cols.name = c("selec.file", "View"), 
c("Raven selection file", "Raven view"))
 
names(rvn.dat2)
}

}
\seealso{
\code{\link{imp_raven}}; \code{\link{exp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
