% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rrelperm-package.R
\name{kr2p_gl}
\alias{kr2p_gl}
\title{Generate a matrix of two-phase relative permeability data for the gas-liquid system using the modified Brooks-Corey model}
\usage{
kr2p_gl(SWCON, SOIRG, SORG, SGCON, SGCRIT, KRGCL, KROGCG, NG, NOG, NP)
}
\arguments{
\item{SWCON}{connate water saturation, fraction}

\item{SOIRG}{irreducible oil saturation, fraction}

\item{SORG}{residual oil saturation, fraction}

\item{SGCON}{connate gas saturation, fraction}

\item{SGCRIT}{critical gas saturation, fraction}

\item{KRGCL}{gas relative permeability at connate liquid}

\item{KROGCG}{oil relative permeability at connate gas}

\item{NG}{exponent term for calculating krg}

\item{NOG}{exponent term for calculating krog}

\item{NP}{number of saturation points in the table, the maximum acceptable value is 501}
}
\value{
A matrix with gas saturation, liquid saturation, gas relative permeability, and oil relative permeability values, respectively
}
\description{
The 'kr2p_gl()' creates a table of two-phase gas and liquid relative permeability data for gas and liquid saturation values between zero and one.
}
\examples{
rel_perm_gl <- kr2p_gl(0.15, 0.1, 0.1, 0.05, 0.05, 0.3, 1, 4, 2.25, 101)

}
\references{
\insertRef{Brooks1964}{Rrelperm}
}
