% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaTransformSeriesToStatSeasonal_ciPercentile}
\alias{tsEvaTransformSeriesToStatSeasonal_ciPercentile}
\title{tsEvaTransformSeriesToStatSeasonal_ciPercentile}
\usage{
tsEvaTransformSeriesToStatSeasonal_ciPercentile(
  timeStamps,
  series,
  timeWindow,
  percentile
)
}
\arguments{
\item{timeStamps}{A vector of time stamps for the time series.}

\item{series}{The original time series.}

\item{timeWindow}{The length of the moving window used for trend estimation.}

\item{percentile}{The percentile value used for computing the slowly varying percentile.}
}
\value{
A list containing the following components:
\describe{
\item{\code{runningStatsMulteplicity}}{The size of each sample used to compute the average}
\item{\code{stationarySeries}}{The transformed stationary series}
\item{\code{trendSeries}}{The trend series}
\item{\code{trendSeriesNonSeasonal}}{The non-seasonal trend series}
\item{\code{stdDevSeries}}{The season-dependent standard deviation series}
\item{\code{stdDevSeriesNonSeasonal}}{The non-seasonal standard deviation series}
\item{\code{trendError}}{The error on the trend}
\item{\code{stdDevError}}{The error on the standard deviation}
\item{\code{statSer3Mom}}{The 3rd moment of the transformed stationary series}
\item{\code{statSer4Mom}}{The 4th moment of the transformed stationary series}
\item{\code{nonStatSeries}}{The original non-stationary series}
\item{\code{Regime}}{The regime of the trend seasonality}
\item{\code{timeStamps}}{The time stamps}
\item{\code{trendNonSeasonalError}}{The error on the non-seasonal trend}
\item{\code{stdDevNonSeasonalError}}{The error on the non-seasonal standard deviation}
\item{\code{trendSeasonalError}}{The error on the seasonal trend}
\item{\code{stdDevSeasonalError}}{The error on the seasonal standard deviation}
}
}
\description{
This function decomposes a time series into a season-dependent trend and a season-dependent standard deviation.
The season-dependent amplitude is given by a seasonal factor multiplied by a slowly varying percentile.
}
\section{this function decomposes the series into a season-dependent trend and a}{
season-dependent standard deviation.
The season-dependent standard deviation is given by a seasonal factor
multiplied by a slowly varying standard deviation.
transformation non stationary -> stationary
x(t) =  (y(t) - trend(t) - ssn_trend(t))/(stdDev(t)*ssn_stdDev(t))
transformation stationary -> non stationary
y(t) = stdDev(t)*ssn_stdDev(t)*x(t) + trend(t) + ssn_trend(t)
trasfData.trendSeries = trend(t) + ssn_trend(t)
trasfData.stdDevSeries = stdDev(t)*ssn_stdDev(t)
}

\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series <- ArdecheStMartin[,2]
#select only the 5 latest years
yrs <- as.integer(format(timeStamps, "\%Y"))
tokeep <- which(yrs>=2015)
timeStamps <- timeStamps[tokeep]
series <- series[tokeep]
timeWindow <- 365 # 1 year
percentile <- 90
result <- tsEvaTransformSeriesToStatSeasonal_ciPercentile(timeStamps,
series, timeWindow, percentile)
plot(result$trendSeries)
}
