% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxrandom.R
\name{rxgamma}
\alias{rxgamma}
\title{Simulate gamma variable from threefry generator}
\usage{
rxgamma(shape, rate = 1/scale, scale = 1, n = 1L, ncores = 1L)
}
\arguments{
\item{shape}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{rate}{an alternative way to specify the scale.}

\item{scale}{shape and scale parameters.  Must be positive,
    \code{scale} strictly.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}

\item{ncores}{Number of cores for the simulation

\code{rxnorm} simulates using the threefry sitmo generator; \code{rxnormV}
uses the vandercorput generator}
}
\value{
gamma random deviates
}
\description{
Care should be taken with this method not to encounter the
birthday problem, described
\url{https://www.johndcook.com/blog/2016/01/29/random-number-generator-seed-mistakes/}.
Since the \code{sitmo} \code{threefry}, this currently generates
one random deviate from the uniform distribution to seed the
engine \code{threefry} and then run the code.
}
\details{
Therefore, a simple call to the random number generated followed by a second
call to random number generated may have identical seeds.  As the number of
random number generator calls are increased the probability that the
birthday problem will increase.

The key to avoid this problem is to either run all simulations in the
\code{RxODE} environment once (therefore one seed or series of seeds
for the whole simulation), pre-generate all random variables
used for the simulation, or seed the RxODE engine with \code{rxSetSeed()}

Also care should be made that the computer you will be running on
can run the same number of cores as you are running so they can
reproduce your results.
}
\examples{
\donttest{

## Use threefry engine

rxgamma(0.5, n = 10) # with rxgamma you have to explicitly state n
rxgamma(5, n = 10, ncores = 2) # You can parallelize the simulation using openMP

rxgamma(1)


## This example uses `rxbeta` directly in the model

rx <- RxODE({
  a <- rxgamma(2)
})

et <- et(1, id = 1:2)

s <- rxSolve(rx, et)
}

}
