% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ryacas-package.R
\docType{package}
\name{Ryacas0-package}
\alias{Ryacas0}
\alias{Ryacas0-package}
\title{R interface to yacas computer algebra package}
\description{
Ryacas0 allows one to use the yacas computer algebra package entirely from
within R.  It takes an R expression, an R one line function or a yacas
string and returns an R expression or a variety of other formats.  It can be
used for symbolic mathematics, exact arithmetic, ASCII pretty printing and R
to TeX conversions.  The main command is \code{yacas} and \code{?yacas}
provides some information on installation and startup.
}
\details{
The following are sources of information on \code{"Ryacas0"}: \tabular{ll}{
DESCRIPTION file\tab library(help = Ryacas0)\cr List of demo files\tab
demo(package = "Ryacas0")\cr Demo file\tab demo("Ryacas0")\cr Demo\tab
demo("Ryacas0-PrettyPrinter")\cr Demo\tab demo("Ryacas0-Function")\cr Demo\tab
demo("Ryacas0-Sym")\cr Demo\tab demo("Ryacas0-Expr")\cr List Vignettes\tab
vignette(package = "Ryacas0")\cr Vignette\tab vignette("Ryacas0")\cr This
File\tab package?Ryacas0\cr Help files\tab ?yacas, ?yacasTranslations,
?yacmode, ?Sym\cr Help files - Windows\tab ?yacasInstall\cr News\tab
RShowDoc("NEWS", package = "Ryacas0")\cr Acknowledgements\tab
RShowDoc("THANKS", package = "Ryacas0")\cr Wish List\tab RShowDoc("WISHLIST",
package = "Ryacas0")\cr Home page\tab https://github.com/r-cas/ryacas0/\cr }
}
\note{
There is a note in the help file of the \link{yacas} command that
discusses a number of installation and startup issues.
}
\examples{

print(yacas(expression(integrate(1/x, x))))
print(yacas("Integrate(x)1/x"))
x <- Sym("x"); Integrate(1/x, x)
acos(Sym("1/2"))

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-cas/ryacas0}
  \item \url{http://www.yacas.org}
  \item Report bugs at \url{https://github.com/r-cas/ryacas0/issues}
}

}
\author{
\strong{Maintainer}: Mikkel Meyer Andersen \email{mikl@math.aau.dk} [copyright holder]

Authors:
\itemize{
  \item Rob Goedman \email{goedman@mac.com} [copyright holder]
  \item Gabor Grothendieck \email{ggrothendieck@gmail.com} [copyright holder]
  \item Søren Højsgaard \email{sorenh@math.aau.dk} [copyright holder]
  \item Grzegorz Mazur \email{teoretyk@gmail.com} [copyright holder]
  \item Ayal Pinkus \email{apinkus@xs4all.nl} [copyright holder]
}

Other contributors:
\itemize{
  \item Nemanja Trifunovic (UTF-8 part of yacas (src/yacas/include/yacas/utf8*)) [copyright holder]
}

}
\keyword{programming}
