% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trustRegion.R
\name{trustRegion}
\alias{trustRegion}
\title{Performs trust region refinement}
\usage{
trustRegion(cobra, center = cobra$xbest)
}
\arguments{
\item{cobra}{an object of class \code{cobra}, which is basically a list  (see \code{\link{cobraInit}})}

\item{center}{[cobra$xbest] the center of the trust region}
}
\value{
the modified \code{cobra} with new/updated elements
     \item{TRDONE}{ logical, is \code{TRUE} if there are more than d+1 points in the trusted 
           region and thus surrogates can be trained. Otherwise \code{FALSE}.}
     \item{trustregX}{ if \code{TRDONE==TRUE} the refined solution from the trust-region call,
           otherwise \code{NA} }
   If \code{TRDONE==TRUE} the relevant lists and counters  (\code{A,Fres,df,...}) 
   of \code{cobra} will be updated in \code{\link{cobraPhaseII}} as well.
}
\description{
If \code{cobra$TrustRegion==TRUE}  (see \code{\link{cobraInit}}), then the \code{trustRegion} functionality is applied
every iteration in order to refine the best solution so far.
This function builds a local model around the best solution and runs a local search in the trust region 
to refine the best solution and find a better solution in the neighborhood.
}
\author{
Samineh Bagheri (\email{samineh.bagheri@th-koeln.de})
}
