% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.OTNetworkSimplex.R
\name{OTNetworkSimplex}
\alias{OTNetworkSimplex}
\title{Optimal Transport Network Simplex solver}
\description{
Solve the optimal transport problem
}
\details{
use the network simplex algorithm
}
\examples{
## Define two dataset
X = stats::rnorm(2000)
Y = stats::rnorm(2000 , mean = 5 )
bw = base::c(0.1)
muX = SBCK::SparseHist( X , bw )
muY = SBCK::SparseHist( Y , bw )

## Find solution
ot = OTNetworkSimplex$new()
ot$fit( muX , muY )

print( sum(ot$plan) ) ## Must be equal to 1
print( ot$success )   ## If solve is success
print( sqrt(sum(ot$plan * ot$C)) ) ## Cost of plan

}
\references{
Bazaraa, M. S., Jarvis, J. J., and Sherali, H. D.: Linear
            Programming and Network Flows, 4th edn., John Wiley & Sons, 2009.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{[double] Power of the plan}

\item{\code{plan}}{[matrix] transport plan}

\item{\code{success}}{[bool] If the fit is a success or not}

\item{\code{C}}{[matrix] Cost matrix}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OTNetworkSimplex$new()}}
\item \href{#method-fit}{\code{OTNetworkSimplex$fit()}}
\item \href{#method-clone}{\code{OTNetworkSimplex$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new OTNetworkSimplex object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTNetworkSimplex$new(p = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[double] Power of the plan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `OTNetworkSimplex` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the OT plan
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTNetworkSimplex$fit(muX0, muX1, C = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{muX0}}{[SparseHist or OTHist] Source histogram to move}

\item{\code{muX1}}{[SparseHist or OTHist] Target histogram}

\item{\code{C}}{[matrix or NULL] Cost matrix (without power p) between muX0 and
muX1, if NULL pairwise_distances is called with Euclidean distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTNetworkSimplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
