% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.Pairwise_distances.R
\name{pairwise_distances}
\alias{pairwise_distances}
\title{Pairwise distances}
\usage{
pairwise_distances(X,Y,metric)
}
\arguments{
\item{X}{[matrix] A first matrix (samples in row, features in columns).}

\item{Y}{[matrix] A second matrix (samples in row, features in columns).
If Y = NULL, then pairwise distances is computed between X and X}

\item{metric}{[string or callable] The metric used. If metric is a string,
then metric is compiled (so faster). Available string are:
"euclidean", "sqeuclidean" (Square of Euclidean distance),
"logeulidean" (log of the Euclidean distance) and "chebyshev" (max). 
Callable must be a function taking two vectors and returning a double.}
}
\value{
distXY [matrix] Pairwise distances. distXY[i,j] is the distance 
        between X[i,] and Y[j,]
}
\description{
Compute the matrix of pairwise distances between a matrix X and a matrix Y
}
\examples{
X = matrix( stats::rnorm(200) , ncol = 100 , nrow = 2 )
Y = matrix( stats::rexp(300)  , ncol = 150 , nrow = 2 )

distXY = SBCK::pairwise_distances( X , Y ) 

}
