% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.QMrs.R
\name{QMrs}
\alias{QMrs}
\title{Quantile Mapping RankShuffle method}
\description{
Perform a multivariate bias correction of X with respect to Y
}
\details{
Dependence is corrected with multi_schaake_shuffle.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period

## Bias correction
## Step 1 : construction of the class QMrs 
qmrs = SBCK::QMrs$new() 
## Step 2 : Fit the bias correction model
qmrs$fit( Y0 , X0 )
## Step 3 : perform the bias correction
Z0 = qmrs$predict(X0)

}
\references{
Vrac, M.: Multivariate bias adjustment of high-dimensional
            climate simulations: the Rank Resampling for Distributions and
            Dependences (R2 D2 ) bias correction, Hydrol. Earth Syst. Sci.,
            22, 3175–3196, https://doi.org/10.5194/hess-22-3175-2018, 2018.
}
\section{Super class}{
\code{\link[SBCK:QM]{SBCK::QM}} -> \code{QMrs}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{irefs}}{[vector of int] Indexes for shuffle. Defaults is base::c(1)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QMrs-new}{\code{QMrs$new()}}
\item \href{#method-QMrs-fit}{\code{QMrs$fit()}}
\item \href{#method-QMrs-predict}{\code{QMrs$predict()}}
\item \href{#method-QMrs-clone}{\code{QMrs$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QMrs-new"></a>}}
\if{latex}{\out{\hypertarget{method-QMrs-new}{}}}
\subsection{Method \code{new()}}{
Create a new QMrs object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QMrs$new(irefs = base::c(1), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{irefs}}{[vector of int] Indexes for shuffle. Defaults is base::c(1)
model}

\item{\code{...}}{[] all others arguments are passed to QM class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `QMrs` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QMrs-fit"></a>}}
\if{latex}{\out{\hypertarget{method-QMrs-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QMrs$fit(Y0, X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QMrs-predict"></a>}}
\if{latex}{\out{\hypertarget{method-QMrs-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QMrs$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix] Return the corrections of X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QMrs-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QMrs-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QMrs$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
