% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parammod.R
\name{param_nbin}
\alias{param_nbin}
\title{Parameter model for Negative Binomial}
\usage{
param_nbin(a0, a1, b0, b1, c0, c1, d0, d1)
}
\arguments{
\item{a0, a1}{\code{mu0 ~ Gamma(a0,a1)}}

\item{b0, b1}{\code{sig_0 ~ Beta(b0,b1)}}

\item{c0, c1}{\code{muk ~ Gamma(c0, c1)}}

\item{d0, d1}{\code{sig_k ~ Beta(d0,d1)}}
}
\value{
\code{parammod} representing Negative-Binomial distributed parameters
}
\description{
Negative Binomial parameter model:
\code{theta_0 = (mu0, sigma0)}
\code{theta_k = (muk, sigmak)}
}
\examples{
## theta0 = (r0, p0); r0~Gamma(1,1); p0 ~ Beta(1,1);
## thetak = (rk, pk); rk~Gamma(3,3); pk ~ Beta(5,5);
pn <- param_nbin(1,1,1,1,3,3,5,5)
pn$r(5) ## a draw with 5 within-block parameters
}
