% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_schema.R
\name{get_schema}
\alias{get_schema}
\title{Get the current schema of a DB connection}
\usage{
get_schema(.x)
}
\arguments{
\item{.x}{A DBIConnection or lazy_query object}
}
\value{
The current schema name, but defaults to "prod" instead of "public"
}
\description{
Get the current schema of a DB connection
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

dplyr::copy_to(conn, mtcars, name = "mtcars")

get_schema(conn)
get_schema(get_table(conn, "mtcars"))

close_connection(conn)
}
