% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCOR.R
\name{SCOptim}
\alias{SCOptim}
\title{Spherically Constrained Optimization}
\usage{
SCOptim(
  x0,
  func,
  rho = 2,
  phi = 0.001,
  max_iter = 50000,
  s_init = 2,
  tol_fun = 1e-06,
  tol_fun_2 = 1e-06,
  minimize = TRUE,
  time = 36000,
  print = FALSE,
  lambda = 0.001,
  parallel = FALSE
)
}
\arguments{
\item{x0}{The initial guess by user}

\item{func}{The function to be optimized}

\item{rho}{Step Decay Rate with default value 2}

\item{phi}{Lower Bound Of Global Step Size. Default value is \eqn{10^{-6}}}

\item{max_iter}{Max Number Of Iterations In each Run. Default Value is 50,000.}

\item{s_init}{Initial Global Step Size. Default Value is 2.}

\item{tol_fun}{Termination Tolerance on the function value. Default Value is \eqn{10^{-6}}}

\item{tol_fun_2}{Termination Tolerance on the difference of solutions in two consecutive runs. Default Value is \eqn{10^{-6}}}

\item{minimize}{Binary Command to set SCOptim on minimization or maximization. TRUE is for minimization which is set default.}

\item{time}{Time Allotted for execution of SCOptim}

\item{print}{Binary Command to print optimized value of objective function after each iteration. FALSE is set fault}

\item{lambda}{Sparsity Threshold. Default value is \eqn{10^{-3}}}

\item{parallel}{Binary Command to ask SCOptim to perform parallel computing. Default is set at FALSE.}
}
\value{
The point where the value Of the Function is maximized under a sphere.
}
\description{
SCOptim runs our optimization algorithm, efficient in estimating maximizing Hyper Volume Under Manifolds Estimators.
}
\details{
SCOptim is the modified version of RMPS,  Recursive Modified Pattern Search.
This is a blackbox algorithm efficient in optimizing non-differentiable functions.
It works great in the shown cases of SHUM, EHUM and ULBA.
}
\examples{
f <- function(x)
return(x[2]^2 + x[3]^3 +x[4]^4)

SCOptim(rep(1,10), f)

SCOptim(c(2,4,6,2,1), f, minimize = FALSE, print = TRUE)
#Will Print the List and Find the Maximum

SCOptim(c(1,2,3,4), f, time = 10, lambda = 1e-2)
#Will perform no iterations after 10 secs, Sparsity Threshold is 0.01

\donttest{
 SCOptim(c(2,6,2,7,8), f, parallel = TRUE)
 #Will do Parallel Computing
}

}
\references{
\itemize{

  \item Das, Priyam and De, Debsurya and Maiti, Raju and Chakraborty, Bibhas and Peterson, Christine B \cr
   "Estimating the Optimal Linear Combination of Biomarkers using Spherically Constrained Optimization" \cr
         (available at `arXiv \url{http://arxiv.org/abs/1909.04024}).
}
}
