% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrabble.R
\name{scrabble}
\alias{scrabble}
\title{Runs SCRABBLE}
\usage{
scrabble(data, parameter, nIter = 20, error_out_threshold = 1e-04,
  nIter_inner = 20, error_inner_threshold = 1e-04)
}
\arguments{
\item{data}{the input data list. The input
data is a list of two datasets, scRNAseq and bulk RNAseq.}

\item{parameter}{the vector of parameters. The first parameter is the value of alpha in the mathematical model
, the second one is the value of beta in the mathematical model.}

\item{nIter}{the maximum iterations, the default is 20.}

\item{error_out_threshold}{the threshold of the error between the current imputed matrix and the previous one.
Default is 1e-4.}

\item{nIter_inner}{the maximum interations of calculating the sub-optimization problem. Default is 20.}

\item{error_inner_threshold}{the threshold of the error between the current updated matrix and the previous one.
Default is 1e-4.}
}
\value{
A data matrix with the same size of the input scRNAseq data
}
\description{
This package imputes drop-out data by optimizing an objective function that consists of three terms.
The first term ensures that imputed values for genes with nonzero expression remain as close to their
original values as possible, thus minimizing unwanted bias towards expressed genes. The second term ensures
the rank of the imputed data matrix to be as small as possible. The rationale is that we only expect a
limited number of distinct cell types in the samples. The third term operates on the bulk RNA-Seq data.
It ensures consistency between the average gene expression of the aggregated imputed data and the
average gene expression of the bulk RNA-Seq data. We developed a convex optimization algorithm to minimize
the objective function.
}
\examples{
# Set up the parameter used in SCRABBLE
parameter <- c(1, 1e-6, 1e-4)

# Run SCRABLE
result <- scrabble(demo_data,parameter = parameter)

}
