% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DICTAUG.R
\name{DICTAUG}
\alias{DICTAUG}
\title{Performs a grid search over the marginal posterior probabilities of inclusion and returns a list of DIC values corresponding to each grid point. This is used in the ReturnModel function.}
\usage{
DICTAUG(PCT1, PCT2, PCT3, COV, Y1, Y2, I1, I2, s1, lam1, s2, lam2, s3, lam3,
  gam, c, B, inc)
}
\arguments{
\item{PCT1}{Vector Containing posterior probabilities of inclusion for the hazard of a non-terminal event. This must be of length ncol(COV)-inc.}

\item{PCT2}{Vector Containing posterior probabilities of inclusion for the hazard of death without a non-terminal event. This must be of length ncol(COV)-inc.}

\item{PCT3}{Vector Containing posterior probabilities of inclusion for the hazard of death after a non-terminal event. This must be of length ncol(COV)-inc.}

\item{COV}{Matrix of Patient Covariates. The last inc will be left out of variable selection.}

\item{Y1}{Vector Containing non-terminal event times (or censoring time due to death/censoring).}

\item{Y2}{Vector Containing Terminal Event times (or censoring).}

\item{I1}{Vector Containing non-terminal event indicators (1 if non-terminal event for a patient, 0 otherwise).}

\item{I2}{Vector Containing Terminal event indicators (1 if a patients experiences a non-ternminal event, 0 if censored).}

\item{s1}{Vector containing the posterior locations of the split points in the hazard of a non-terminal event.}

\item{lam1}{Vector containing the posterior log hazard heights on the split point intervals in the hazard of a non-terminal event.}

\item{s2}{Vector containing the posterior locations of the split points in the hazard of death without a non-terminal event.}

\item{lam2}{Vector containing the posterior log hazard heights on the split point intervals in the hazard of death without a non-terminal event.}

\item{s3}{Vector containing the posterior locations of the split points in the hazard of death after a non-terminal event.}

\item{lam3}{Vector containing the posterior log hazard heights on the split point intervals in the hazard of death after a non-terminal event.}

\item{gam}{Vector of length n containing the posterior mean frailties of the patients.}

\item{c}{Hyperparameter involved in the sampling of hazard coefficients. This should be the same value that controls the degree of sparsity achieved by the SVSS.}

\item{B}{Number of iterations}

\item{inc}{Number of variables left out of selection}
}
\value{
Returns a list of size 18 containing 18x18 matrices of DIC values and skipped entries.

 @references
[1] Lee, K. H., Haneuse, S., Schrag, D. and Dominici, F. (2015), Bayesian semi-parametric analysis of semi-competing risks data: investigating hospital readmission after a pancreatic cancer diagnosis. Journal of the Royal Statistical Society: Series C (Applied Statistics), 64: 253-273. doi: 10.1111/rssc.12078
[2] Chapple, A.C., Vannucci, M., Thall, P.F., Lin, S.(2017), Bayesian Variable selection for a semi-competing risks model with three hazard functions. Journal of Computational Statistics & Data Analysis, Volume 112, August 2017, Pages 170-185
[3] https://adventuresinstatistics.wordpress.com/2017/04/10/package-scrselect-using-returnmodel/
}
\description{
Performs a grid search over the marginal posterior probabilities of inclusion and returns a list of DIC values corresponding to each grid point. This is used in the ReturnModel function.
}
\examples{
####Randomly Generate Semicompeting Risks Data
####Generates random patient time, indicator and covariates.
set.seed(1)
n=100
Y1=runif(n,0,100)
I1=rbinom(n,1,.5)
Y2=Y1
I2=I1
for(i in 1:n){if(I1[i]==0){Y2[i]=Y1[i]}else{Y2[i]=Y1[i]+runif(1,0,100)}}
I2=rbinom(n,1,.5)
library(mvtnorm)
X=rmvnorm(n,rep(0,7),diag(7))
###Read in Posterior mean quantities from SCRSELECTRETURN
PCT1=c(.2,.4,.7,.8,.5)
PCT2=c(.02,.06,.1,.5,.7)
PCT3=c(.85,.87,.3,.45,.51)
gam=rgamma(n,1,1)
s1=c(0,3,5,max(Y1[I1==1]))
lam1=c(-1,-3,0)
s2=c(0,1,max(Y2[I1==0]))
lam2=c(0,-2)
s3=c(0,max(Y2[I1==1]))
lam3=-2
####Read in Hyperparameters
c=5
###Number of iterations and output location
B=4
###Number of variables to exclude from selection and burnin percent
inc=2
DICTAUG(PCT1,PCT2,PCT3,X,Y1,Y2,I1,I2,s1,lam1,s2,lam2,s3,lam3,gam,c,B,inc)
}
