% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_RidgePlot.R
\name{do_RidgePlot}
\alias{do_RidgePlot}
\title{Create ridge plots.}
\usage{
do_RidgePlot(
  sample,
  feature,
  group.by = NULL,
  split.by = NULL,
  assay = "SCT",
  slot = "data",
  continuous_scale = FALSE,
  legend.title = NULL,
  legend.ncol = NULL,
  legend.nrow = NULL,
  legend.byrow = FALSE,
  legend.position = NULL,
  legend.width = 1,
  legend.length = 20,
  legend.framewidth = 0.5,
  legend.tickwidth = 0.5,
  legend.framecolor = "grey50",
  legend.tickcolor = "white",
  legend.type = "colorbar",
  colors.use = NULL,
  font.size = 14,
  font.type = "sans",
  rotate_x_axis_labels = 45,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  xlab = NULL,
  ylab = NULL,
  compute_quantiles = FALSE,
  compute_custom_quantiles = FALSE,
  quantiles = c(0.25, 0.5, 0.75),
  compute_distribution_tails = FALSE,
  prob_tails = 0.025,
  color_by_probabilities = FALSE,
  viridis_color_map = "G",
  viridis_direction = 1,
  plot.grid = TRUE,
  grid.color = "grey75",
  grid.type = "dashed",
  flip = FALSE
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{feature}{\strong{\code{\link[base]{character}}} | Feature to represent.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Secondary metadata variable to further group (split) the output by. Has to be a character of factor column.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{continuous_scale}{\strong{\code{\link[base]{logical}}} | Whether to color the ridges depending on a categorical or continuous scale.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns in the legend.}

\item{legend.nrow}{\strong{\code{\link[base]{numeric}}} | Number of rows in the legend.}

\item{legend.byrow}{\strong{\code{\link[base]{logical}}} | Whether the legend is filled by row or not.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
\item \emph{\code{colorsteps}}: Redefined legend with colors going by range, in steps, using \link[ggplot2]{guide_colorsteps}.
}}

\item{colors.use}{\strong{\code{\link[base]{character}}} | Named vector of colors to use. Has to match the unique values of group.by or color.by (if used) when scale_type is set to categorical.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{rotate_x_axis_labels}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{compute_quantiles}{\strong{\code{\link[base]{logical}}} | Whether to compute quantiles of the distribution and color the ridge plots by them.}

\item{compute_custom_quantiles}{\strong{\code{\link[base]{logical}}} | Whether to compute custom quantiles.}

\item{quantiles}{\strong{\code{\link[base]{numeric}}} | Numeric vector of quantiles.}

\item{compute_distribution_tails}{\strong{\code{\link[base]{logical}}} | Whether to compute distribution tails and color them.}

\item{prob_tails}{\strong{\code{\link[base]{numeric}}} | The accumulated probability that the tails should contain.}

\item{color_by_probabilities}{\strong{\code{\link[base]{logical}}} | Whether to color the ridges depending on the probability.}

\item{viridis_color_map}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis_direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the panels.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}
}
\value{
A ggplot2 object.
}
\description{
This function computes ridge plots based on the \pkg{ggridges} package.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_RidgePlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Compute the most basic ridge plot.
    p <- SCpubr::do_RidgePlot(sample = sample,
                              feature = "nFeature_RNA")
    p

    # Use continuous color scale.
    p <- SCpubr::do_RidgePlot(sample = sample,
                              feature = "nFeature_RNA",
                              continuous_scale = TRUE,
                              viridis_direction = 1)
    p

    # Draw quantiles of the distribution.
    p <- SCpubr::do_RidgePlot(sample = sample,
                              feature = "nFeature_RNA",
                              continuous_scale = TRUE,
                              compute_quantiles = TRUE,
                              compute_custom_quantiles = TRUE)
    p

    # Draw probability tails.
    p <- SCpubr::do_RidgePlot(sample = sample,
                              feature = "nFeature_RNA",
                              continuous_scale = TRUE,
                              compute_quantiles = TRUE,
                              compute_distribution_tails = TRUE)
    p

    # Draw probability tails.
    p <- SCpubr::do_RidgePlot(sample = sample,
                              feature = "nFeature_RNA",
                              continuous_scale = TRUE,
                              compute_quantiles = TRUE,
                              color_by_probabilities = TRUE)
    p
  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
