% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_DotPlot.R
\name{do_DotPlot}
\alias{do_DotPlot}
\title{This function is a wrapper for \link[Seurat]{DotPlot}. It provides most of its functionalities while adding extra.
You can}
\usage{
do_DotPlot(
  sample,
  features,
  assay = NULL,
  group.by = NULL,
  scale = FALSE,
  legend.title = NULL,
  legend.type = "colorbar",
  legend.position = "bottom",
  legend.framewidth = 0.5,
  legend.tickwidth = 0.5,
  legend.length = 20,
  legend.width = 1,
  legend.framecolor = "grey50",
  legend.tickcolor = "white",
  colors.use = NULL,
  dot.scale = 6,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  xlab = NULL,
  ylab = NULL,
  font.size = 14,
  font.type = "sans",
  cluster = FALSE,
  flip = FALSE,
  axis.text.x.angle = 45,
  scale.by = "size",
  use_viridis = FALSE,
  viridis.palette = "G",
  viridis.direction = -1,
  sequential.palette = "YlGnBu",
  sequential.direction = 1,
  na.value = "grey75",
  dot_border = TRUE,
  plot.grid = TRUE,
  grid.color = "grey75",
  grid.type = "dashed",
  number.breaks = 5,
  plot.title.face = "bold",
  plot.subtitle.face = "plain",
  plot.caption.face = "italic",
  axis.title.face = "bold",
  axis.text.face = "plain",
  legend.title.face = "bold",
  legend.text.face = "plain"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{features}{\strong{\code{\link[base]{character}}} | Features to represent.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{scale}{\strong{\code{\link[base]{logical}}} | Whether the data should be scaled or not. Non-scaled data allows for comparison across genes. Scaled data allows for an easier comparison along the same gene.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{dot.scale}{\strong{\code{\link[base]{numeric}}} | Scale the size of the dots.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{cluster}{\strong{\code{\link[base]{logical}}} | Whether to cluster the identities based on the expression of the features.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{axis.text.x.angle}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{scale.by}{\strong{\code{\link[base]{character}}} | How to scale the size of the dots. One of:
\itemize{
\item \emph{\code{radius}}: use radius aesthetic.
\item \emph{\code{size}}: use size aesthetic.
}}

\item{use_viridis}{\strong{\code{\link[base]{logical}}} | Whether to use viridis color scales.}

\item{viridis.palette}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis.direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{sequential.palette}{\strong{\code{\link[base]{character}}} | Type of sequential color palette to use. Out of the sequential palettes defined in \strong{\code{\link[RColorBrewer]{brewer.pal}}}.}

\item{sequential.direction}{\strong{\code{\link[base]{numeric}}} | Direction of the sequential color scale. Either 1 or -1.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{dot_border}{\strong{\code{\link[base]{logical}}} | Whether to plot a border around dots.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the plot. In heatmaps, color of the border of the cells.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{number.breaks}{\strong{\code{\link[base]{numeric}}} | Controls the number of breaks in continuous color scales of ggplot2-based plots.}

\item{plot.title.face, plot.subtitle.face, plot.caption.face, axis.title.face, axis.text.face, legend.title.face, legend.text.face}{\strong{\code{\link[base]{character}}} | Controls the style of the font for the corresponding theme element.  One of:
\itemize{
\item \emph{\code{plain}}: For normal text.
\item \emph{\code{italic}}: For text in itallic.
\item \emph{\code{bold}}: For text in bold.
\item \emph{\code{bold.italic}}: For text both in itallic and bold.
}}
}
\value{
A ggplot2 object containing a Dot Plot.
}
\description{
This function is a wrapper for \link[Seurat]{DotPlot}. It provides most of its functionalities while adding extra.
You can
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_DotPlot", passive = TRUE)

  if (isTRUE(value)){
    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic Dot plot.
    p <- SCpubr::do_DotPlot(sample = sample,
                            features = "EPC1")

    # Querying multiple features.
    genes <- rownames(sample)[1:14]
    p <- SCpubr::do_DotPlot(sample = sample,
                            features = genes)

    # Inverting the axes.
    p <- SCpubr::do_DotPlot(sample = sample,
                            features = genes,
                            cluster = TRUE,
                            plot.title = "Clustered",
                            flip = TRUE)

    # Modifying default colors.
    # Two colors to generate a gradient.
    p <- SCpubr::do_DotPlot(sample = sample,
                            features = genes,
                            colors.use = c("#001219", "#e9d8a6"))

    # Querying multiple features as a named list - splitting by each item in list.
    # Genes have to be unique.
    genes <- list("Naive CD4+ T" = rownames(sample)[1:2],
                  "EPC1+ Mono" = rownames(sample)[3:4],
                  "Memory CD4+" = rownames(sample)[5],
                  "B" = rownames(sample)[6],
                  "CD8+ T" = rownames(sample)[7],
                  "FCGR3A+ Mono" = rownames(sample)[8:9],
                  "NK" = rownames(sample)[10:11],
                  "DC" = rownames(sample)[12:13],
                  "Platelet" = rownames(sample)[14])

    p <- SCpubr::do_DotPlot(sample = sample,
                            features = genes)

    # Clustering the identities.
    p <- SCpubr::do_DotPlot(sample = sample,
                            features = genes,
                            cluster = TRUE,
                            plot.title = "Clustered")
  } else if (base::isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
